<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Invia ServiceType
 * @subpackage Services
 */
class Invia extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named InviaPresenza
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InviaPresenza $parameters
     * @return \StructType\InviaPresenzaResponse|bool
     */
    public function InviaPresenza(\StructType\InviaPresenza $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InviaPresenza($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InviaPresenza2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InviaPresenza2 $parameters
     * @return \StructType\InviaPresenza2Response|bool
     */
    public function InviaPresenza2(\StructType\InviaPresenza2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InviaPresenza2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InviaPresenza3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InviaPresenza3 $parameters
     * @return \StructType\InviaPresenza3Response|bool
     */
    public function InviaPresenza3(\StructType\InviaPresenza3 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InviaPresenza3($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\InviaPresenza2Response|\StructType\InviaPresenza3Response|\StructType\InviaPresenzaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
