<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://eschenker-fat.dbschenker.com/webservice/bookingWebServiceV1_1?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://eschenker-fat.dbschenker.com/webservice/bookingWebServiceV1_1?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \DBSchenker\ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \DBSchenker\ServiceType\Get($options);
/**
 * Sample call for getBookingRequestLand operation/method
 */
if ($get->getBookingRequestLand(new \DBSchenker\StructType\GetBookingRequestLand()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getBookingRequestAir operation/method
 */
if ($get->getBookingRequestAir(new \DBSchenker\StructType\GetBookingRequestAir()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getBookingRequestOceanLCL operation/method
 */
if ($get->getBookingRequestOceanLCL(new \DBSchenker\StructType\GetBookingOceanLCL()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getBookingRequestOceanFCL operation/method
 */
if ($get->getBookingRequestOceanFCL(new \DBSchenker\StructType\GetBookingOceanFCL()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getBookingBarcodeRequest operation/method
 */
if ($get->getBookingBarcodeRequest(new \DBSchenker\StructType\GetBarcodeRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getBookingCancelRequest operation/method
 */
if ($get->getBookingCancelRequest(new \DBSchenker\StructType\GetCancelRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
