<?php

namespace DBSchenker\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for vesselDateType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines vessel date
 * @subpackage Structs
 */
class VesselDateType extends AbstractStructBase
{
    /**
     * The date
     * Meta information extracted from the WSDL
     * - documentation: Defines vessel date
     * - minOccurs: 1
     * @var string
     */
    public $date;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $type;
    /**
     * Constructor method for vesselDateType
     * @uses VesselDateType::setDate()
     * @uses VesselDateType::setType()
     * @param string $date
     * @param string $type
     */
    public function __construct($date = null, $type = null)
    {
        $this
            ->setDate($date)
            ->setType($type);
    }
    /**
     * Get date value
     * @return string
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \DBSchenker\StructType\VesselDateType
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \DBSchenker\EnumType\Type::valueIsValid()
     * @uses \DBSchenker\EnumType\Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \DBSchenker\StructType\VesselDateType
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\DBSchenker\EnumType\Type::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DBSchenker\EnumType\Type', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \DBSchenker\EnumType\Type::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
}
