<?php

namespace DBSchenker\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sentApplicable StructType
 * Meta information extracted from the WSDL
 * - documentation: Can only be applied for bookings with departure or destination country PL.
 * @subpackage Structs
 */
class SentApplicable extends AbstractStructBase
{
    /**
     * The sentNumber
     * Meta information extracted from the WSDL
     * - documentation: Please enter 14 digits received from PUESC platform as SENT number
     * - base: xs:string
     * - pattern: [0-9]{14}
     * @var string
     */
    public $sentNumber;
    /**
     * The sentCarrierUpdateKey
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: KD-[1-9]{2}[XLANTCYDRUEFZPHMJSKW]{2}
     * @var string
     */
    public $sentCarrierUpdateKey;
    /**
     * Constructor method for sentApplicable
     * @uses SentApplicable::setSentNumber()
     * @uses SentApplicable::setSentCarrierUpdateKey()
     * @param string $sentNumber
     * @param string $sentCarrierUpdateKey
     */
    public function __construct($sentNumber = null, $sentCarrierUpdateKey = null)
    {
        $this
            ->setSentNumber($sentNumber)
            ->setSentCarrierUpdateKey($sentCarrierUpdateKey);
    }
    /**
     * Get sentNumber value
     * @return string|null
     */
    public function getSentNumber()
    {
        return $this->sentNumber;
    }
    /**
     * Set sentNumber value
     * @param string $sentNumber
     * @return \DBSchenker\StructType\SentApplicable
     */
    public function setSentNumber($sentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($sentNumber) && !is_string($sentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sentNumber, true), gettype($sentNumber)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{14})
        if (!is_null($sentNumber) && !preg_match('/[0-9]{14}/', $sentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{14}', var_export($sentNumber, true)), __LINE__);
        }
        $this->sentNumber = $sentNumber;
        return $this;
    }
    /**
     * Get sentCarrierUpdateKey value
     * @return string|null
     */
    public function getSentCarrierUpdateKey()
    {
        return $this->sentCarrierUpdateKey;
    }
    /**
     * Set sentCarrierUpdateKey value
     * @param string $sentCarrierUpdateKey
     * @return \DBSchenker\StructType\SentApplicable
     */
    public function setSentCarrierUpdateKey($sentCarrierUpdateKey = null)
    {
        // validation for constraint: string
        if (!is_null($sentCarrierUpdateKey) && !is_string($sentCarrierUpdateKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sentCarrierUpdateKey, true), gettype($sentCarrierUpdateKey)), __LINE__);
        }
        // validation for constraint: pattern(KD-[1-9]{2}[XLANTCYDRUEFZPHMJSKW]{2})
        if (!is_null($sentCarrierUpdateKey) && !preg_match('/KD-[1-9]{2}[XLANTCYDRUEFZPHMJSKW]{2}/', $sentCarrierUpdateKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression KD-[1-9]{2}[XLANTCYDRUEFZPHMJSKW]{2}', var_export($sentCarrierUpdateKey, true)), __LINE__);
        }
        $this->sentCarrierUpdateKey = $sentCarrierUpdateKey;
        return $this;
    }
}
