<?php

namespace DBSchenker\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for reference StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines reference
 * @subpackage Structs
 */
class Reference extends AbstractStructBase
{
    /**
     * The number
     * Meta information extracted from the WSDL
     * - documentation: Defines reference number
     * - base: xs:string
     * - maxLength: 100
     * - minOccurs: 1
     * @var string
     */
    public $number;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - documentation: Defines reference type
     * - minOccurs: 1
     * @var string
     */
    public $id;
    /**
     * Constructor method for reference
     * @uses Reference::setNumber()
     * @uses Reference::setId()
     * @param string $number
     * @param string $id
     */
    public function __construct($number = null, $id = null)
    {
        $this
            ->setNumber($number)
            ->setId($id);
    }
    /**
     * Get number value
     * @return string
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \DBSchenker\StructType\Reference
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($number) && mb_strlen($number) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @uses \DBSchenker\EnumType\ReferenceIdType::valueIsValid()
     * @uses \DBSchenker\EnumType\ReferenceIdType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $id
     * @return \DBSchenker\StructType\Reference
     */
    public function setId($id = null)
    {
        // validation for constraint: enumeration
        if (!\DBSchenker\EnumType\ReferenceIdType::valueIsValid($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DBSchenker\EnumType\ReferenceIdType', is_array($id) ? implode(', ', $id) : var_export($id, true), implode(', ', \DBSchenker\EnumType\ReferenceIdType::getValidValues())), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
}
