<?php

namespace DBSchenker\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for preAdvise StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines preAdvise
 * @subpackage Structs
 */
class PreAdvise extends AbstractStructBase
{
    /**
     * The contact
     * Meta information extracted from the WSDL
     * - documentation: Defines contact | The contact person's name.
     * - base: xs:string
     * - maxLength: 1000
     * - minOccurs: 1
     * @var string
     */
    public $contact;
    /**
     * The phone
     * Meta information extracted from the WSDL
     * - documentation: Defines phone | Defines contact phone | The contact person's phone number.
     * - base: xs:string
     * - maxLength: 1000
     * - minOccurs: 1
     * @var string
     */
    public $phone;
    /**
     * Constructor method for preAdvise
     * @uses PreAdvise::setContact()
     * @uses PreAdvise::setPhone()
     * @param string $contact
     * @param string $phone
     */
    public function __construct($contact = null, $phone = null)
    {
        $this
            ->setContact($contact)
            ->setPhone($phone);
    }
    /**
     * Get contact value
     * @return string
     */
    public function getContact()
    {
        return $this->contact;
    }
    /**
     * Set contact value
     * @param string $contact
     * @return \DBSchenker\StructType\PreAdvise
     */
    public function setContact($contact = null)
    {
        // validation for constraint: string
        if (!is_null($contact) && !is_string($contact)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contact, true), gettype($contact)), __LINE__);
        }
        // validation for constraint: maxLength(1000)
        if (!is_null($contact) && mb_strlen($contact) > 1000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1000', mb_strlen($contact)), __LINE__);
        }
        $this->contact = $contact;
        return $this;
    }
    /**
     * Get phone value
     * @return string
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \DBSchenker\StructType\PreAdvise
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        // validation for constraint: maxLength(1000)
        if (!is_null($phone) && mb_strlen($phone) > 1000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1000', mb_strlen($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
}
