<?php

namespace DBSchenker\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for pickupDate StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines pickup dates
 * @subpackage Structs
 */
class PickupDate extends AbstractStructBase
{
    /**
     * The pickUpDateFrom
     * Meta information extracted from the WSDL
     * - documentation: Defines pick up date From
     * - minOccurs: 1
     * @var string
     */
    public $pickUpDateFrom;
    /**
     * The pickUpDateTo
     * Meta information extracted from the WSDL
     * - documentation: Defines pick up date To
     * - minOccurs: 1
     * @var string
     */
    public $pickUpDateTo;
    /**
     * Constructor method for pickupDate
     * @uses PickupDate::setPickUpDateFrom()
     * @uses PickupDate::setPickUpDateTo()
     * @param string $pickUpDateFrom
     * @param string $pickUpDateTo
     */
    public function __construct($pickUpDateFrom = null, $pickUpDateTo = null)
    {
        $this
            ->setPickUpDateFrom($pickUpDateFrom)
            ->setPickUpDateTo($pickUpDateTo);
    }
    /**
     * Get pickUpDateFrom value
     * @return string
     */
    public function getPickUpDateFrom()
    {
        return $this->pickUpDateFrom;
    }
    /**
     * Set pickUpDateFrom value
     * @param string $pickUpDateFrom
     * @return \DBSchenker\StructType\PickupDate
     */
    public function setPickUpDateFrom($pickUpDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($pickUpDateFrom) && !is_string($pickUpDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickUpDateFrom, true), gettype($pickUpDateFrom)), __LINE__);
        }
        $this->pickUpDateFrom = $pickUpDateFrom;
        return $this;
    }
    /**
     * Get pickUpDateTo value
     * @return string
     */
    public function getPickUpDateTo()
    {
        return $this->pickUpDateTo;
    }
    /**
     * Set pickUpDateTo value
     * @param string $pickUpDateTo
     * @return \DBSchenker\StructType\PickupDate
     */
    public function setPickUpDateTo($pickUpDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($pickUpDateTo) && !is_string($pickUpDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickUpDateTo, true), gettype($pickUpDateTo)), __LINE__);
        }
        $this->pickUpDateTo = $pickUpDateTo;
        return $this;
    }
}
