<?php

namespace DBSchenker\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for landEquipmentType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines land equipment type
 * @subpackage Structs
 */
class LandEquipmentType extends AbstractStructBase
{
    /**
     * The vehicleType
     * @var string
     */
    public $vehicleType;
    /**
     * The formatType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $formatType;
    /**
     * The bodyType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bodyType;
    /**
     * The technologyType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $technologyType;
    /**
     * Constructor method for landEquipmentType
     * @uses LandEquipmentType::setVehicleType()
     * @uses LandEquipmentType::setFormatType()
     * @uses LandEquipmentType::setBodyType()
     * @uses LandEquipmentType::setTechnologyType()
     * @param string $vehicleType
     * @param string $formatType
     * @param string $bodyType
     * @param string $technologyType
     */
    public function __construct($vehicleType = null, $formatType = null, $bodyType = null, $technologyType = null)
    {
        $this
            ->setVehicleType($vehicleType)
            ->setFormatType($formatType)
            ->setBodyType($bodyType)
            ->setTechnologyType($technologyType);
    }
    /**
     * Get vehicleType value
     * @return string|null
     */
    public function getVehicleType()
    {
        return $this->vehicleType;
    }
    /**
     * Set vehicleType value
     * @uses \DBSchenker\EnumType\VehicleType::valueIsValid()
     * @uses \DBSchenker\EnumType\VehicleType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vehicleType
     * @return \DBSchenker\StructType\LandEquipmentType
     */
    public function setVehicleType($vehicleType = null)
    {
        // validation for constraint: enumeration
        if (!\DBSchenker\EnumType\VehicleType::valueIsValid($vehicleType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DBSchenker\EnumType\VehicleType', is_array($vehicleType) ? implode(', ', $vehicleType) : var_export($vehicleType, true), implode(', ', \DBSchenker\EnumType\VehicleType::getValidValues())), __LINE__);
        }
        $this->vehicleType = $vehicleType;
        return $this;
    }
    /**
     * Get formatType value
     * @return string|null
     */
    public function getFormatType()
    {
        return $this->formatType;
    }
    /**
     * Set formatType value
     * @uses \DBSchenker\EnumType\FormatType::valueIsValid()
     * @uses \DBSchenker\EnumType\FormatType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $formatType
     * @return \DBSchenker\StructType\LandEquipmentType
     */
    public function setFormatType($formatType = null)
    {
        // validation for constraint: enumeration
        if (!\DBSchenker\EnumType\FormatType::valueIsValid($formatType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DBSchenker\EnumType\FormatType', is_array($formatType) ? implode(', ', $formatType) : var_export($formatType, true), implode(', ', \DBSchenker\EnumType\FormatType::getValidValues())), __LINE__);
        }
        $this->formatType = $formatType;
        return $this;
    }
    /**
     * Get bodyType value
     * @return string|null
     */
    public function getBodyType()
    {
        return $this->bodyType;
    }
    /**
     * Set bodyType value
     * @uses \DBSchenker\EnumType\BodyType::valueIsValid()
     * @uses \DBSchenker\EnumType\BodyType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bodyType
     * @return \DBSchenker\StructType\LandEquipmentType
     */
    public function setBodyType($bodyType = null)
    {
        // validation for constraint: enumeration
        if (!\DBSchenker\EnumType\BodyType::valueIsValid($bodyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DBSchenker\EnumType\BodyType', is_array($bodyType) ? implode(', ', $bodyType) : var_export($bodyType, true), implode(', ', \DBSchenker\EnumType\BodyType::getValidValues())), __LINE__);
        }
        $this->bodyType = $bodyType;
        return $this;
    }
    /**
     * Get technologyType value
     * @return string|null
     */
    public function getTechnologyType()
    {
        return $this->technologyType;
    }
    /**
     * Set technologyType value
     * @uses \DBSchenker\EnumType\TechnologyType::valueIsValid()
     * @uses \DBSchenker\EnumType\TechnologyType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $technologyType
     * @return \DBSchenker\StructType\LandEquipmentType
     */
    public function setTechnologyType($technologyType = null)
    {
        // validation for constraint: enumeration
        if (!\DBSchenker\EnumType\TechnologyType::valueIsValid($technologyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DBSchenker\EnumType\TechnologyType', is_array($technologyType) ? implode(', ', $technologyType) : var_export($technologyType, true), implode(', ', \DBSchenker\EnumType\TechnologyType::getValidValues())), __LINE__);
        }
        $this->technologyType = $technologyType;
        return $this;
    }
}
