<?php

namespace DBSchenker\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for externalBarcodeResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: Holds Barcode Response
 * @subpackage Structs
 */
class ExternalBarcodeResponse extends AbstractStructBase
{
    /**
     * The applicationArea
     * Meta information extracted from the WSDL
     * - documentation: Holds access request ID of the request, which will be returned with response
     * - minOccurs: 1
     * @var \DBSchenker\StructType\ApplicationAreaResponse
     */
    public $applicationArea;
    /**
     * The document
     * @var string
     */
    public $document;
    /**
     * The noBarcodeAvailable
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - pattern: [\d]{6}-[\d]{6}
     * @var string[]
     */
    public $noBarcodeAvailable;
    /**
     * Constructor method for externalBarcodeResponse
     * @uses ExternalBarcodeResponse::setApplicationArea()
     * @uses ExternalBarcodeResponse::setDocument()
     * @uses ExternalBarcodeResponse::setNoBarcodeAvailable()
     * @param \DBSchenker\StructType\ApplicationAreaResponse $applicationArea
     * @param string $document
     * @param string[] $noBarcodeAvailable
     */
    public function __construct(\DBSchenker\StructType\ApplicationAreaResponse $applicationArea = null, $document = null, array $noBarcodeAvailable = array())
    {
        $this
            ->setApplicationArea($applicationArea)
            ->setDocument($document)
            ->setNoBarcodeAvailable($noBarcodeAvailable);
    }
    /**
     * Get applicationArea value
     * @return \DBSchenker\StructType\ApplicationAreaResponse
     */
    public function getApplicationArea()
    {
        return $this->applicationArea;
    }
    /**
     * Set applicationArea value
     * @param \DBSchenker\StructType\ApplicationAreaResponse $applicationArea
     * @return \DBSchenker\StructType\ExternalBarcodeResponse
     */
    public function setApplicationArea(\DBSchenker\StructType\ApplicationAreaResponse $applicationArea = null)
    {
        $this->applicationArea = $applicationArea;
        return $this;
    }
    /**
     * Get document value
     * @return string|null
     */
    public function getDocument()
    {
        return $this->document;
    }
    /**
     * Set document value
     * @param string $document
     * @return \DBSchenker\StructType\ExternalBarcodeResponse
     */
    public function setDocument($document = null)
    {
        // validation for constraint: string
        if (!is_null($document) && !is_string($document)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($document, true), gettype($document)), __LINE__);
        }
        $this->document = $document;
        return $this;
    }
    /**
     * Get noBarcodeAvailable value
     * @return string[]|null
     */
    public function getNoBarcodeAvailable()
    {
        return $this->noBarcodeAvailable;
    }
    /**
     * This method is responsible for validating the values passed to the setNoBarcodeAvailable method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNoBarcodeAvailable method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNoBarcodeAvailableForArrayConstraintsFromSetNoBarcodeAvailable(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $externalBarcodeResponseNoBarcodeAvailableItem) {
            // validation for constraint: itemType
            if (!is_string($externalBarcodeResponseNoBarcodeAvailableItem)) {
                $invalidValues[] = is_object($externalBarcodeResponseNoBarcodeAvailableItem) ? get_class($externalBarcodeResponseNoBarcodeAvailableItem) : sprintf('%s(%s)', gettype($externalBarcodeResponseNoBarcodeAvailableItem), var_export($externalBarcodeResponseNoBarcodeAvailableItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The noBarcodeAvailable property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set noBarcodeAvailable value
     * @param string[] $noBarcodeAvailable
     * @return \DBSchenker\StructType\ExternalBarcodeResponse
     */
    public function setNoBarcodeAvailable(array $noBarcodeAvailable = array())
    {
        // validation for constraint: list
        if ('' !== ($noBarcodeAvailableArrayErrorMessage = self::validateNoBarcodeAvailableForArrayConstraintsFromSetNoBarcodeAvailable($noBarcodeAvailable))) {
            throw new \InvalidArgumentException($noBarcodeAvailableArrayErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([\d]{6}-[\d]{6})
        if (!is_null($noBarcodeAvailable) && !preg_match('/[\\d]{6}-[\\d]{6}/', $noBarcodeAvailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\d]{6}-[\d]{6}', var_export($noBarcodeAvailable, true)), __LINE__);
        }
        $this->noBarcodeAvailable = is_array($noBarcodeAvailable) ? implode(' ', $noBarcodeAvailable) : null;
        return $this;
    }
}
