<?php

namespace DBSchenker\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for declarantInformation StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines declarant information
 * @subpackage Structs
 */
class DeclarantInformation extends AbstractStructBase
{
    /**
     * The companyName
     * Meta information extracted from the WSDL
     * - documentation: Defines companyName
     * - base: xs:string
     * - maxLength: 35
     * - minOccurs: 0
     * @var string
     */
    public $companyName;
    /**
     * The street
     * Meta information extracted from the WSDL
     * - documentation: Defines street information | Defines street
     * - base: xs:string
     * - maxLength: 35
     * - minOccurs: 0
     * @var string
     */
    public $street;
    /**
     * The postalCode
     * Meta information extracted from the WSDL
     * - documentation: Defines postal code | Defines postalCode
     * - base: xs:string
     * - maxLength: 10
     * - minOccurs: 0
     * @var string
     */
    public $postalCode;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - documentation: Defines city
     * - base: xs:string
     * - maxLength: 35
     * - minOccurs: 0
     * @var string
     */
    public $city;
    /**
     * The countryCode
     * Meta information extracted from the WSDL
     * - documentation: Defines code of the country | Defines countryCode
     * - base: xs:string
     * - maxLength: 10
     * - minOccurs: 0
     * @var string
     */
    public $countryCode;
    /**
     * The phone
     * Meta information extracted from the WSDL
     * - documentation: Defines phone | Defines contact phone | The contact person's phone number.
     * - base: xs:string
     * - maxLength: 250
     * - minOccurs: 0
     * @var string
     */
    public $phone;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - documentation: Defines email address | Defines email of contact person | Defines email | The contact person's email address.
     * - base: xs:string
     * - maxLength: 250
     * - minOccurs: 0
     * - pattern: [^@]+@[^\.]+\..+
     * @var string
     */
    public $email;
    /**
     * Constructor method for declarantInformation
     * @uses DeclarantInformation::setCompanyName()
     * @uses DeclarantInformation::setStreet()
     * @uses DeclarantInformation::setPostalCode()
     * @uses DeclarantInformation::setCity()
     * @uses DeclarantInformation::setCountryCode()
     * @uses DeclarantInformation::setPhone()
     * @uses DeclarantInformation::setEmail()
     * @param string $companyName
     * @param string $street
     * @param string $postalCode
     * @param string $city
     * @param string $countryCode
     * @param string $phone
     * @param string $email
     */
    public function __construct($companyName = null, $street = null, $postalCode = null, $city = null, $countryCode = null, $phone = null, $email = null)
    {
        $this
            ->setCompanyName($companyName)
            ->setStreet($street)
            ->setPostalCode($postalCode)
            ->setCity($city)
            ->setCountryCode($countryCode)
            ->setPhone($phone)
            ->setEmail($email);
    }
    /**
     * Get companyName value
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->companyName;
    }
    /**
     * Set companyName value
     * @param string $companyName
     * @return \DBSchenker\StructType\DeclarantInformation
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyName, true), gettype($companyName)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($companyName) && mb_strlen($companyName) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($companyName)), __LINE__);
        }
        $this->companyName = $companyName;
        return $this;
    }
    /**
     * Get street value
     * @return string|null
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param string $street
     * @return \DBSchenker\StructType\DeclarantInformation
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($street) && mb_strlen($street) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($street)), __LINE__);
        }
        $this->street = $street;
        return $this;
    }
    /**
     * Get postalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->postalCode;
    }
    /**
     * Set postalCode value
     * @param string $postalCode
     * @return \DBSchenker\StructType\DeclarantInformation
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($postalCode) && mb_strlen($postalCode) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($postalCode)), __LINE__);
        }
        $this->postalCode = $postalCode;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \DBSchenker\StructType\DeclarantInformation
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($city) && mb_strlen($city) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get countryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->countryCode;
    }
    /**
     * Set countryCode value
     * @param string $countryCode
     * @return \DBSchenker\StructType\DeclarantInformation
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($countryCode) && mb_strlen($countryCode) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($countryCode)), __LINE__);
        }
        $this->countryCode = $countryCode;
        return $this;
    }
    /**
     * Get phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \DBSchenker\StructType\DeclarantInformation
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        // validation for constraint: maxLength(250)
        if (!is_null($phone) && mb_strlen($phone) > 250) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 250', mb_strlen($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \DBSchenker\StructType\DeclarantInformation
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        // validation for constraint: maxLength(250)
        if (!is_null($email) && mb_strlen($email) > 250) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 250', mb_strlen($email)), __LINE__);
        }
        // validation for constraint: pattern([^@]+@[^\.]+\..+)
        if (!is_null($email) && !preg_match('/[^@]+@[^\\.]+\\..+/', $email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [^@]+@[^\.]+\..+', var_export($email, true)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
}
