<?php

namespace DBSchenker\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for dangerousGoodsType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines dangerous goods
 * @subpackage Structs
 */
class DangerousGoodsType extends AbstractStructBase
{
    /**
     * The packageType
     * Meta information extracted from the WSDL
     * - documentation: Defines shipment position package type | Specifies dangerous goods package type
     * - base: xs:string
     * - maxLength: 50
     * - minOccurs: 1
     * @var string
     */
    public $packageType;
    /**
     * The weightType
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $weightType;
    /**
     * The weight
     * Meta information extracted from the WSDL
     * - documentation: Specifies dangerous goods weight
     * - minOccurs: 1
     * @var string
     */
    public $weight;
    /**
     * The subitems
     * Meta information extracted from the WSDL
     * - documentation: Holds list of dangerous goods UnNo numbers
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * - nillable: true
     * @var \DBSchenker\StructType\DangerousGoodsUnNoType[]
     */
    public $subitems;
    /**
     * The pieces
     * Meta information extracted from the WSDL
     * - documentation: Specifies dangerous goods pieces amount
     * @var int
     */
    public $pieces;
    /**
     * The weightBasis
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $weightBasis;
    /**
     * Constructor method for dangerousGoodsType
     * @uses DangerousGoodsType::setPackageType()
     * @uses DangerousGoodsType::setWeightType()
     * @uses DangerousGoodsType::setWeight()
     * @uses DangerousGoodsType::setSubitems()
     * @uses DangerousGoodsType::setPieces()
     * @uses DangerousGoodsType::setWeightBasis()
     * @param string $packageType
     * @param string $weightType
     * @param string $weight
     * @param \DBSchenker\StructType\DangerousGoodsUnNoType[] $subitems
     * @param int $pieces
     * @param string $weightBasis
     */
    public function __construct($packageType = null, $weightType = null, $weight = null, array $subitems = array(), $pieces = null, $weightBasis = null)
    {
        $this
            ->setPackageType($packageType)
            ->setWeightType($weightType)
            ->setWeight($weight)
            ->setSubitems($subitems)
            ->setPieces($pieces)
            ->setWeightBasis($weightBasis);
    }
    /**
     * Get packageType value
     * @return string
     */
    public function getPackageType()
    {
        return $this->packageType;
    }
    /**
     * Set packageType value
     * @param string $packageType
     * @return \DBSchenker\StructType\DangerousGoodsType
     */
    public function setPackageType($packageType = null)
    {
        // validation for constraint: string
        if (!is_null($packageType) && !is_string($packageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageType, true), gettype($packageType)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($packageType) && mb_strlen($packageType) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($packageType)), __LINE__);
        }
        $this->packageType = $packageType;
        return $this;
    }
    /**
     * Get weightType value
     * @return string
     */
    public function getWeightType()
    {
        return $this->weightType;
    }
    /**
     * Set weightType value
     * @uses \DBSchenker\EnumType\WeightType::valueIsValid()
     * @uses \DBSchenker\EnumType\WeightType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $weightType
     * @return \DBSchenker\StructType\DangerousGoodsType
     */
    public function setWeightType($weightType = null)
    {
        // validation for constraint: enumeration
        if (!\DBSchenker\EnumType\WeightType::valueIsValid($weightType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DBSchenker\EnumType\WeightType', is_array($weightType) ? implode(', ', $weightType) : var_export($weightType, true), implode(', ', \DBSchenker\EnumType\WeightType::getValidValues())), __LINE__);
        }
        $this->weightType = $weightType;
        return $this;
    }
    /**
     * Get weight value
     * @return string
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param string $weight
     * @return \DBSchenker\StructType\DangerousGoodsType
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: string
        if (!is_null($weight) && !is_string($weight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->weight = $weight;
        return $this;
    }
    /**
     * Get subitems value
     * @return \DBSchenker\StructType\DangerousGoodsUnNoType[]
     */
    public function getSubitems()
    {
        return $this->subitems;
    }
    /**
     * This method is responsible for validating the values passed to the setSubitems method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubitems method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubitemsForArrayConstraintsFromSetSubitems(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dangerousGoodsTypeSubitemsItem) {
            // validation for constraint: itemType
            if (!$dangerousGoodsTypeSubitemsItem instanceof \DBSchenker\StructType\DangerousGoodsUnNoType) {
                $invalidValues[] = is_object($dangerousGoodsTypeSubitemsItem) ? get_class($dangerousGoodsTypeSubitemsItem) : sprintf('%s(%s)', gettype($dangerousGoodsTypeSubitemsItem), var_export($dangerousGoodsTypeSubitemsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The subitems property can only contain items of type \DBSchenker\StructType\DangerousGoodsUnNoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set subitems value
     * @throws \InvalidArgumentException
     * @param \DBSchenker\StructType\DangerousGoodsUnNoType[] $subitems
     * @return \DBSchenker\StructType\DangerousGoodsType
     */
    public function setSubitems(array $subitems = array())
    {
        // validation for constraint: array
        if ('' !== ($subitemsArrayErrorMessage = self::validateSubitemsForArrayConstraintsFromSetSubitems($subitems))) {
            throw new \InvalidArgumentException($subitemsArrayErrorMessage, __LINE__);
        }
        $this->subitems = $subitems;
        return $this;
    }
    /**
     * Add item to subitems value
     * @throws \InvalidArgumentException
     * @param \DBSchenker\StructType\DangerousGoodsUnNoType $item
     * @return \DBSchenker\StructType\DangerousGoodsType
     */
    public function addToSubitems(\DBSchenker\StructType\DangerousGoodsUnNoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \DBSchenker\StructType\DangerousGoodsUnNoType) {
            throw new \InvalidArgumentException(sprintf('The subitems property can only contain items of type \DBSchenker\StructType\DangerousGoodsUnNoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->subitems[] = $item;
        return $this;
    }
    /**
     * Get pieces value
     * @return int|null
     */
    public function getPieces()
    {
        return $this->pieces;
    }
    /**
     * Set pieces value
     * @param int $pieces
     * @return \DBSchenker\StructType\DangerousGoodsType
     */
    public function setPieces($pieces = null)
    {
        // validation for constraint: int
        if (!is_null($pieces) && !(is_int($pieces) || ctype_digit($pieces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pieces, true), gettype($pieces)), __LINE__);
        }
        $this->pieces = $pieces;
        return $this;
    }
    /**
     * Get weightBasis value
     * @return string|null
     */
    public function getWeightBasis()
    {
        return $this->weightBasis;
    }
    /**
     * Set weightBasis value
     * @uses \DBSchenker\EnumType\WeightBasis::valueIsValid()
     * @uses \DBSchenker\EnumType\WeightBasis::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $weightBasis
     * @return \DBSchenker\StructType\DangerousGoodsType
     */
    public function setWeightBasis($weightBasis = null)
    {
        // validation for constraint: enumeration
        if (!\DBSchenker\EnumType\WeightBasis::valueIsValid($weightBasis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DBSchenker\EnumType\WeightBasis', is_array($weightBasis) ? implode(', ', $weightBasis) : var_export($weightBasis, true), implode(', ', \DBSchenker\EnumType\WeightBasis::getValidValues())), __LINE__);
        }
        $this->weightBasis = $weightBasis;
        return $this;
    }
}
