<?php

namespace DBSchenker\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cancelRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines Cancel Request Type
 * @subpackage Structs
 */
class CancelRequestType extends AbstractStructBase
{
    /**
     * The bookingId
     * Meta information extracted from the WSDL
     * - documentation: Holds the canceled booking ID
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [\d]{6}-[\d]{6}
     * @var string
     */
    public $bookingId;
    /**
     * Constructor method for cancelRequestType
     * @uses CancelRequestType::setBookingId()
     * @param string $bookingId
     */
    public function __construct($bookingId = null)
    {
        $this
            ->setBookingId($bookingId);
    }
    /**
     * Get bookingId value
     * @return string
     */
    public function getBookingId()
    {
        return $this->bookingId;
    }
    /**
     * Set bookingId value
     * @param string $bookingId
     * @return \DBSchenker\StructType\CancelRequestType
     */
    public function setBookingId($bookingId = null)
    {
        // validation for constraint: string
        if (!is_null($bookingId) && !is_string($bookingId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingId, true), gettype($bookingId)), __LINE__);
        }
        // validation for constraint: pattern([\d]{6}-[\d]{6})
        if (!is_null($bookingId) && !preg_match('/[\\d]{6}-[\\d]{6}/', $bookingId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\d]{6}-[\d]{6}', var_export($bookingId, true)), __LINE__);
        }
        $this->bookingId = $bookingId;
        return $this;
    }
}
