<?php

namespace DBSchenker\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bookingOceanLCLType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines Ocean Booking (LCL and FCL)
 * @subpackage Structs
 */
class BookingOceanLCLType extends BookingType
{
    /**
     * The serviceType
     * Meta information extracted from the WSDL
     * - documentation: Defines service type: D2D, D2P, P2D, P2P
     * - minOccurs: 1
     * @var string
     */
    public $serviceType;
    /**
     * The shippingInformation
     * Meta information extracted from the WSDL
     * - documentation: Holds the ocean lcl shipping information
     * - minOccurs: 1
     * @var \DBSchenker\StructType\ShippingInformationType
     */
    public $shippingInformation;
    /**
     * The myOceanBusiness
     * Meta information extracted from the WSDL
     * - documentation: Defines "My Ocean Business"
     * - base: xs:string
     * - maxLength: 500
     * - minOccurs: 0
     * @var string
     */
    public $myOceanBusiness;
    /**
     * The portDischarge
     * Meta information extracted from the WSDL
     * - documentation: Holds port of discharge
     * - base: xs:string
     * - length: 5
     * - minOccurs: 0
     * @var string
     */
    public $portDischarge;
    /**
     * The portLoading
     * Meta information extracted from the WSDL
     * - documentation: Defines port of loading
     * - base: xs:string
     * - length: 5
     * - minOccurs: 0
     * @var string
     */
    public $portLoading;
    /**
     * The precarriageType
     * Meta information extracted from the WSDL
     * - documentation: Specifies precarriage type: PICKUP_REQUEST or OWN_DELIVERY; only for Ocean (LCL)
     * - minOccurs: 0
     * @var string
     */
    public $precarriageType;
    /**
     * The positioningType
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 30
     * - minOccurs: 0
     * @var string
     */
    public $positioningType;
    /**
     * The latestDeliveryDate
     * Meta information extracted from the WSDL
     * - documentation: Latest delivery date
     * - minOccurs: 0
     * @var string
     */
    public $latestDeliveryDate;
    /**
     * The vesselDates
     * Meta information extracted from the WSDL
     * - documentation: Holds list of vessel dates. Deprecated, use latestDeliveryDate instead.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \DBSchenker\StructType\VesselDateType[]
     */
    public $vesselDates;
    /**
     * The vesselName
     * Meta information extracted from the WSDL
     * - documentation: Defines vessel name. Deprecated, will not be available in next version.
     * - base: xs:string
     * - maxLength: 250
     * - minOccurs: 0
     * @var string
     */
    public $vesselName;
    /**
     * Constructor method for bookingOceanLCLType
     * @uses BookingOceanLCLType::setServiceType()
     * @uses BookingOceanLCLType::setShippingInformation()
     * @uses BookingOceanLCLType::setMyOceanBusiness()
     * @uses BookingOceanLCLType::setPortDischarge()
     * @uses BookingOceanLCLType::setPortLoading()
     * @uses BookingOceanLCLType::setPrecarriageType()
     * @uses BookingOceanLCLType::setPositioningType()
     * @uses BookingOceanLCLType::setLatestDeliveryDate()
     * @uses BookingOceanLCLType::setVesselDates()
     * @uses BookingOceanLCLType::setVesselName()
     * @param string $serviceType
     * @param \DBSchenker\StructType\ShippingInformationType $shippingInformation
     * @param string $myOceanBusiness
     * @param string $portDischarge
     * @param string $portLoading
     * @param string $precarriageType
     * @param string $positioningType
     * @param string $latestDeliveryDate
     * @param \DBSchenker\StructType\VesselDateType[] $vesselDates
     * @param string $vesselName
     */
    public function __construct($serviceType = null, \DBSchenker\StructType\ShippingInformationType $shippingInformation = null, $myOceanBusiness = null, $portDischarge = null, $portLoading = null, $precarriageType = null, $positioningType = null, $latestDeliveryDate = null, array $vesselDates = array(), $vesselName = null)
    {
        $this
            ->setServiceType($serviceType)
            ->setShippingInformation($shippingInformation)
            ->setMyOceanBusiness($myOceanBusiness)
            ->setPortDischarge($portDischarge)
            ->setPortLoading($portLoading)
            ->setPrecarriageType($precarriageType)
            ->setPositioningType($positioningType)
            ->setLatestDeliveryDate($latestDeliveryDate)
            ->setVesselDates($vesselDates)
            ->setVesselName($vesselName);
    }
    /**
     * Get serviceType value
     * @return string
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @uses \DBSchenker\EnumType\ServiceOceanType::valueIsValid()
     * @uses \DBSchenker\EnumType\ServiceOceanType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceType
     * @return \DBSchenker\StructType\BookingOceanLCLType
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: enumeration
        if (!\DBSchenker\EnumType\ServiceOceanType::valueIsValid($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DBSchenker\EnumType\ServiceOceanType', is_array($serviceType) ? implode(', ', $serviceType) : var_export($serviceType, true), implode(', ', \DBSchenker\EnumType\ServiceOceanType::getValidValues())), __LINE__);
        }
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Get shippingInformation value
     * @return \DBSchenker\StructType\ShippingInformationType
     */
    public function getShippingInformation()
    {
        return $this->shippingInformation;
    }
    /**
     * Set shippingInformation value
     * @param \DBSchenker\StructType\ShippingInformationType $shippingInformation
     * @return \DBSchenker\StructType\BookingOceanLCLType
     */
    public function setShippingInformation(\DBSchenker\StructType\ShippingInformationType $shippingInformation = null)
    {
        $this->shippingInformation = $shippingInformation;
        return $this;
    }
    /**
     * Get myOceanBusiness value
     * @return string|null
     */
    public function getMyOceanBusiness()
    {
        return $this->myOceanBusiness;
    }
    /**
     * Set myOceanBusiness value
     * @param string $myOceanBusiness
     * @return \DBSchenker\StructType\BookingOceanLCLType
     */
    public function setMyOceanBusiness($myOceanBusiness = null)
    {
        // validation for constraint: string
        if (!is_null($myOceanBusiness) && !is_string($myOceanBusiness)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($myOceanBusiness, true), gettype($myOceanBusiness)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($myOceanBusiness) && mb_strlen($myOceanBusiness) > 500) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen($myOceanBusiness)), __LINE__);
        }
        $this->myOceanBusiness = $myOceanBusiness;
        return $this;
    }
    /**
     * Get portDischarge value
     * @return string|null
     */
    public function getPortDischarge()
    {
        return $this->portDischarge;
    }
    /**
     * Set portDischarge value
     * @param string $portDischarge
     * @return \DBSchenker\StructType\BookingOceanLCLType
     */
    public function setPortDischarge($portDischarge = null)
    {
        // validation for constraint: string
        if (!is_null($portDischarge) && !is_string($portDischarge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($portDischarge, true), gettype($portDischarge)), __LINE__);
        }
        // validation for constraint: length(5)
        if (!is_null($portDischarge) && mb_strlen($portDischarge) !== 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 5', mb_strlen($portDischarge)), __LINE__);
        }
        $this->portDischarge = $portDischarge;
        return $this;
    }
    /**
     * Get portLoading value
     * @return string|null
     */
    public function getPortLoading()
    {
        return $this->portLoading;
    }
    /**
     * Set portLoading value
     * @param string $portLoading
     * @return \DBSchenker\StructType\BookingOceanLCLType
     */
    public function setPortLoading($portLoading = null)
    {
        // validation for constraint: string
        if (!is_null($portLoading) && !is_string($portLoading)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($portLoading, true), gettype($portLoading)), __LINE__);
        }
        // validation for constraint: length(5)
        if (!is_null($portLoading) && mb_strlen($portLoading) !== 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 5', mb_strlen($portLoading)), __LINE__);
        }
        $this->portLoading = $portLoading;
        return $this;
    }
    /**
     * Get precarriageType value
     * @return string|null
     */
    public function getPrecarriageType()
    {
        return $this->precarriageType;
    }
    /**
     * Set precarriageType value
     * @uses \DBSchenker\EnumType\PrecarriageType::valueIsValid()
     * @uses \DBSchenker\EnumType\PrecarriageType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $precarriageType
     * @return \DBSchenker\StructType\BookingOceanLCLType
     */
    public function setPrecarriageType($precarriageType = null)
    {
        // validation for constraint: enumeration
        if (!\DBSchenker\EnumType\PrecarriageType::valueIsValid($precarriageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DBSchenker\EnumType\PrecarriageType', is_array($precarriageType) ? implode(', ', $precarriageType) : var_export($precarriageType, true), implode(', ', \DBSchenker\EnumType\PrecarriageType::getValidValues())), __LINE__);
        }
        $this->precarriageType = $precarriageType;
        return $this;
    }
    /**
     * Get positioningType value
     * @return string|null
     */
    public function getPositioningType()
    {
        return $this->positioningType;
    }
    /**
     * Set positioningType value
     * @uses \DBSchenker\EnumType\PositioningType::valueIsValid()
     * @uses \DBSchenker\EnumType\PositioningType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $positioningType
     * @return \DBSchenker\StructType\BookingOceanLCLType
     */
    public function setPositioningType($positioningType = null)
    {
        // validation for constraint: enumeration
        if (!\DBSchenker\EnumType\PositioningType::valueIsValid($positioningType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DBSchenker\EnumType\PositioningType', is_array($positioningType) ? implode(', ', $positioningType) : var_export($positioningType, true), implode(', ', \DBSchenker\EnumType\PositioningType::getValidValues())), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($positioningType) && mb_strlen($positioningType) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($positioningType)), __LINE__);
        }
        $this->positioningType = $positioningType;
        return $this;
    }
    /**
     * Get latestDeliveryDate value
     * @return string|null
     */
    public function getLatestDeliveryDate()
    {
        return $this->latestDeliveryDate;
    }
    /**
     * Set latestDeliveryDate value
     * @param string $latestDeliveryDate
     * @return \DBSchenker\StructType\BookingOceanLCLType
     */
    public function setLatestDeliveryDate($latestDeliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($latestDeliveryDate) && !is_string($latestDeliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($latestDeliveryDate, true), gettype($latestDeliveryDate)), __LINE__);
        }
        $this->latestDeliveryDate = $latestDeliveryDate;
        return $this;
    }
    /**
     * Get vesselDates value
     * @return \DBSchenker\StructType\VesselDateType[]|null
     */
    public function getVesselDates()
    {
        return $this->vesselDates;
    }
    /**
     * This method is responsible for validating the values passed to the setVesselDates method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVesselDates method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVesselDatesForArrayConstraintsFromSetVesselDates(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bookingOceanLCLTypeVesselDatesItem) {
            // validation for constraint: itemType
            if (!$bookingOceanLCLTypeVesselDatesItem instanceof \DBSchenker\StructType\VesselDateType) {
                $invalidValues[] = is_object($bookingOceanLCLTypeVesselDatesItem) ? get_class($bookingOceanLCLTypeVesselDatesItem) : sprintf('%s(%s)', gettype($bookingOceanLCLTypeVesselDatesItem), var_export($bookingOceanLCLTypeVesselDatesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The vesselDates property can only contain items of type \DBSchenker\StructType\VesselDateType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set vesselDates value
     * @throws \InvalidArgumentException
     * @param \DBSchenker\StructType\VesselDateType[] $vesselDates
     * @return \DBSchenker\StructType\BookingOceanLCLType
     */
    public function setVesselDates(array $vesselDates = array())
    {
        // validation for constraint: array
        if ('' !== ($vesselDatesArrayErrorMessage = self::validateVesselDatesForArrayConstraintsFromSetVesselDates($vesselDates))) {
            throw new \InvalidArgumentException($vesselDatesArrayErrorMessage, __LINE__);
        }
        $this->vesselDates = $vesselDates;
        return $this;
    }
    /**
     * Add item to vesselDates value
     * @throws \InvalidArgumentException
     * @param \DBSchenker\StructType\VesselDateType $item
     * @return \DBSchenker\StructType\BookingOceanLCLType
     */
    public function addToVesselDates(\DBSchenker\StructType\VesselDateType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \DBSchenker\StructType\VesselDateType) {
            throw new \InvalidArgumentException(sprintf('The vesselDates property can only contain items of type \DBSchenker\StructType\VesselDateType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->vesselDates[] = $item;
        return $this;
    }
    /**
     * Get vesselName value
     * @return string|null
     */
    public function getVesselName()
    {
        return $this->vesselName;
    }
    /**
     * Set vesselName value
     * @param string $vesselName
     * @return \DBSchenker\StructType\BookingOceanLCLType
     */
    public function setVesselName($vesselName = null)
    {
        // validation for constraint: string
        if (!is_null($vesselName) && !is_string($vesselName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vesselName, true), gettype($vesselName)), __LINE__);
        }
        // validation for constraint: maxLength(250)
        if (!is_null($vesselName) && mb_strlen($vesselName) > 250) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 250', mb_strlen($vesselName)), __LINE__);
        }
        $this->vesselName = $vesselName;
        return $this;
    }
}
