<?php

namespace DBSchenker\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for barcodeRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines Barcode Request Type
 * @subpackage Structs
 */
class BarcodeRequestType extends AbstractStructBase
{
    /**
     * The format
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \DBSchenker\StructType\Format
     */
    public $format;
    /**
     * The bookingId
     * Meta information extracted from the WSDL
     * - documentation: Holds response booking ID
     * - base: xs:string
     * - maxOccurs: 999
     * - minOccurs: 1
     * - pattern: [\d]{6}-[\d]{6}
     * @var string[]
     */
    public $bookingId;
    /**
     * The barcodeRequestEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \DBSchenker\StructType\BarcodeRequestEmailType
     */
    public $barcodeRequestEmail;
    /**
     * Constructor method for barcodeRequestType
     * @uses BarcodeRequestType::setFormat()
     * @uses BarcodeRequestType::setBookingId()
     * @uses BarcodeRequestType::setBarcodeRequestEmail()
     * @param \DBSchenker\StructType\Format $format
     * @param string[] $bookingId
     * @param \DBSchenker\StructType\BarcodeRequestEmailType $barcodeRequestEmail
     */
    public function __construct(\DBSchenker\StructType\Format $format = null, array $bookingId = array(), \DBSchenker\StructType\BarcodeRequestEmailType $barcodeRequestEmail = null)
    {
        $this
            ->setFormat($format)
            ->setBookingId($bookingId)
            ->setBarcodeRequestEmail($barcodeRequestEmail);
    }
    /**
     * Get format value
     * @return \DBSchenker\StructType\Format
     */
    public function getFormat()
    {
        return $this->format;
    }
    /**
     * Set format value
     * @param \DBSchenker\StructType\Format $format
     * @return \DBSchenker\StructType\BarcodeRequestType
     */
    public function setFormat(\DBSchenker\StructType\Format $format = null)
    {
        $this->format = $format;
        return $this;
    }
    /**
     * Get bookingId value
     * @return string[]
     */
    public function getBookingId()
    {
        return $this->bookingId;
    }
    /**
     * This method is responsible for validating the values passed to the setBookingId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBookingId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBookingIdForArrayConstraintsFromSetBookingId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $barcodeRequestTypeBookingIdItem) {
            // validation for constraint: itemType
            if (!is_string($barcodeRequestTypeBookingIdItem)) {
                $invalidValues[] = is_object($barcodeRequestTypeBookingIdItem) ? get_class($barcodeRequestTypeBookingIdItem) : sprintf('%s(%s)', gettype($barcodeRequestTypeBookingIdItem), var_export($barcodeRequestTypeBookingIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The bookingId property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set bookingId value
     * @throws \InvalidArgumentException
     * @param string[] $bookingId
     * @return \DBSchenker\StructType\BarcodeRequestType
     */
    public function setBookingId(array $bookingId = array())
    {
        // validation for constraint: array
        if ('' !== ($bookingIdArrayErrorMessage = self::validateBookingIdForArrayConstraintsFromSetBookingId($bookingId))) {
            throw new \InvalidArgumentException($bookingIdArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(999)
        if (is_array($bookingId) && count($bookingId) > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 999', count($bookingId)), __LINE__);
        }
        // validation for constraint: pattern([\d]{6}-[\d]{6})
        if (!is_null($bookingId) && !preg_match('/[\\d]{6}-[\\d]{6}/', $bookingId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\d]{6}-[\d]{6}', var_export($bookingId, true)), __LINE__);
        }
        $this->bookingId = $bookingId;
        return $this;
    }
    /**
     * Add item to bookingId value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \DBSchenker\StructType\BarcodeRequestType
     */
    public function addToBookingId($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The bookingId property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(999)
        if (is_array($this->bookingId) && count($this->bookingId) >= 999) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 999', count($this->bookingId)), __LINE__);
        }
        // validation for constraint: pattern([\d]{6}-[\d]{6})
        if (!preg_match('/[\\d]{6}-[\\d]{6}/', $item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\d]{6}-[\d]{6}', var_export($item, true)), __LINE__);
        }
        $this->bookingId[] = $item;
        return $this;
    }
    /**
     * Get barcodeRequestEmail value
     * @return \DBSchenker\StructType\BarcodeRequestEmailType|null
     */
    public function getBarcodeRequestEmail()
    {
        return $this->barcodeRequestEmail;
    }
    /**
     * Set barcodeRequestEmail value
     * @param \DBSchenker\StructType\BarcodeRequestEmailType $barcodeRequestEmail
     * @return \DBSchenker\StructType\BarcodeRequestType
     */
    public function setBarcodeRequestEmail(\DBSchenker\StructType\BarcodeRequestEmailType $barcodeRequestEmail = null)
    {
        $this->barcodeRequestEmail = $barcodeRequestEmail;
        return $this;
    }
}
