<?php

namespace DBSchenker\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for applicationAreaRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Access Key of booking creator(person)
 * @subpackage Structs
 */
class ApplicationAreaRequest extends AbstractStructBase
{
    /**
     * The accessKey
     * Meta information extracted from the WSDL
     * - documentation: Holds the access key (user token)
     * - base: xs:string
     * - maxLength: 100
     * - minOccurs: 1
     * @var string
     */
    public $accessKey;
    /**
     * The groupId
     * Meta information extracted from the WSDL
     * - documentation: Holds optional user group id
     * - minOccurs: 0
     * @var int
     */
    public $groupId;
    /**
     * The requestID
     * Meta information extracted from the WSDL
     * - documentation: Defines request ID, which will be returned with response
     * - base: xs:string
     * - maxLength: 500
     * - minOccurs: 0
     * @var string
     */
    public $requestID;
    /**
     * The userId
     * Meta information extracted from the WSDL
     * - documentation: Defines the user id for which the booking should be done
     * - minOccurs: 0
     * @var string
     */
    public $userId;
    /**
     * The groupName
     * Meta information extracted from the WSDL
     * - documentation: Defines the group name for which the booking should be done
     * - minOccurs: 0
     * @var string
     */
    public $groupName;
    /**
     * Constructor method for applicationAreaRequest
     * @uses ApplicationAreaRequest::setAccessKey()
     * @uses ApplicationAreaRequest::setGroupId()
     * @uses ApplicationAreaRequest::setRequestID()
     * @uses ApplicationAreaRequest::setUserId()
     * @uses ApplicationAreaRequest::setGroupName()
     * @param string $accessKey
     * @param int $groupId
     * @param string $requestID
     * @param string $userId
     * @param string $groupName
     */
    public function __construct($accessKey = null, $groupId = null, $requestID = null, $userId = null, $groupName = null)
    {
        $this
            ->setAccessKey($accessKey)
            ->setGroupId($groupId)
            ->setRequestID($requestID)
            ->setUserId($userId)
            ->setGroupName($groupName);
    }
    /**
     * Get accessKey value
     * @return string
     */
    public function getAccessKey()
    {
        return $this->accessKey;
    }
    /**
     * Set accessKey value
     * @param string $accessKey
     * @return \DBSchenker\StructType\ApplicationAreaRequest
     */
    public function setAccessKey($accessKey = null)
    {
        // validation for constraint: string
        if (!is_null($accessKey) && !is_string($accessKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessKey, true), gettype($accessKey)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($accessKey) && mb_strlen($accessKey) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($accessKey)), __LINE__);
        }
        $this->accessKey = $accessKey;
        return $this;
    }
    /**
     * Get groupId value
     * @return int|null
     */
    public function getGroupId()
    {
        return $this->groupId;
    }
    /**
     * Set groupId value
     * @param int $groupId
     * @return \DBSchenker\StructType\ApplicationAreaRequest
     */
    public function setGroupId($groupId = null)
    {
        // validation for constraint: int
        if (!is_null($groupId) && !(is_int($groupId) || ctype_digit($groupId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($groupId, true), gettype($groupId)), __LINE__);
        }
        $this->groupId = $groupId;
        return $this;
    }
    /**
     * Get requestID value
     * @return string|null
     */
    public function getRequestID()
    {
        return $this->requestID;
    }
    /**
     * Set requestID value
     * @param string $requestID
     * @return \DBSchenker\StructType\ApplicationAreaRequest
     */
    public function setRequestID($requestID = null)
    {
        // validation for constraint: string
        if (!is_null($requestID) && !is_string($requestID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestID, true), gettype($requestID)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($requestID) && mb_strlen($requestID) > 500) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen($requestID)), __LINE__);
        }
        $this->requestID = $requestID;
        return $this;
    }
    /**
     * Get userId value
     * @return string|null
     */
    public function getUserId()
    {
        return $this->userId;
    }
    /**
     * Set userId value
     * @param string $userId
     * @return \DBSchenker\StructType\ApplicationAreaRequest
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        $this->userId = $userId;
        return $this;
    }
    /**
     * Get groupName value
     * @return string|null
     */
    public function getGroupName()
    {
        return $this->groupName;
    }
    /**
     * Set groupName value
     * @param string $groupName
     * @return \DBSchenker\StructType\ApplicationAreaRequest
     */
    public function setGroupName($groupName = null)
    {
        // validation for constraint: string
        if (!is_null($groupName) && !is_string($groupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupName, true), gettype($groupName)), __LINE__);
        }
        $this->groupName = $groupName;
        return $this;
    }
}
