<?php

namespace DBSchenker\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getBookingRequestLand
     * Meta information extracted from the WSDL
     * - documentation: Booking Web Service operation to create Land bookings
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DBSchenker\StructType\GetBookingRequestLand $parameters
     * @return \DBSchenker\StructType\GetBookingResponse|bool
     */
    public function getBookingRequestLand(\DBSchenker\StructType\GetBookingRequestLand $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getBookingRequestLand($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBookingRequestAir
     * Meta information extracted from the WSDL
     * - documentation: Booking Web Service operation to create Air bookings
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DBSchenker\StructType\GetBookingRequestAir $parameters
     * @return \DBSchenker\StructType\GetBookingResponse|bool
     */
    public function getBookingRequestAir(\DBSchenker\StructType\GetBookingRequestAir $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getBookingRequestAir($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBookingRequestOceanLCL
     * Meta information extracted from the WSDL
     * - documentation: Booking Web Service operation to create Ocean LCL bookings
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DBSchenker\StructType\GetBookingOceanLCL $parameters
     * @return \DBSchenker\StructType\GetBookingResponse|bool
     */
    public function getBookingRequestOceanLCL(\DBSchenker\StructType\GetBookingOceanLCL $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getBookingRequestOceanLCL($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBookingRequestOceanFCL
     * Meta information extracted from the WSDL
     * - documentation: Booking Web Service operation to create Ocean FCL bookings
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DBSchenker\StructType\GetBookingOceanFCL $parameters
     * @return \DBSchenker\StructType\GetBookingResponse|bool
     */
    public function getBookingRequestOceanFCL(\DBSchenker\StructType\GetBookingOceanFCL $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getBookingRequestOceanFCL($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBookingBarcodeRequest
     * Meta information extracted from the WSDL
     * - documentation: Booking Web Service operation to get a barcode based on a booking id
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DBSchenker\StructType\GetBarcodeRequest $parameters
     * @return \DBSchenker\StructType\GetBarcodeResponse|bool
     */
    public function getBookingBarcodeRequest(\DBSchenker\StructType\GetBarcodeRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getBookingBarcodeRequest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBookingCancelRequest
     * Meta information extracted from the WSDL
     * - documentation: Booking Web Service operation to cancel a booking by booking id
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \DBSchenker\StructType\GetCancelRequest $parameters
     * @return \DBSchenker\StructType\GetCancelResponse|bool
     */
    public function getBookingCancelRequest(\DBSchenker\StructType\GetCancelRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getBookingCancelRequest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \DBSchenker\StructType\GetBarcodeResponse|\DBSchenker\StructType\GetBookingResponse|\DBSchenker\StructType\GetCancelResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
