<?php

namespace DBSchenker\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for weightType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Specifies dangerous goods weight type: KGS, LBS, LITER
 * @subpackage Enumerations
 */
class WeightType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'KGS'
     * @return string 'KGS'
     */
    const VALUE_KGS = 'KGS';
    /**
     * Constant for value 'LBS'
     * @return string 'LBS'
     */
    const VALUE_LBS = 'LBS';
    /**
     * Constant for value 'LITER'
     * @return string 'LITER'
     */
    const VALUE_LITER = 'LITER';
    /**
     * Return allowed values
     * @uses self::VALUE_KGS
     * @uses self::VALUE_LBS
     * @uses self::VALUE_LITER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_KGS,
            self::VALUE_LBS,
            self::VALUE_LITER,
        );
    }
}
