<?php

namespace DBSchenker\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for weightBasis EnumType
 * Meta information extracted from the WSDL
 * - documentation: Specifies dangerous goods weight basis: NET or GROSS; should be empty when 'weightType' is LITER
 * @subpackage Enumerations
 */
class WeightBasis extends AbstractStructEnumBase
{
    /**
     * Constant for value 'NET'
     * @return string 'NET'
     */
    const VALUE_NET = 'NET';
    /**
     * Constant for value 'GROSS'
     * @return string 'GROSS'
     */
    const VALUE_GROSS = 'GROSS';
    /**
     * Return allowed values
     * @uses self::VALUE_NET
     * @uses self::VALUE_GROSS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NET,
            self::VALUE_GROSS,
        );
    }
}
