<?php

namespace DBSchenker\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for type EnumType
 * Meta information extracted from the WSDL
 * - documentation: Defines equipment type | Defines vessel date type: LATEST_ARR, LATEST_DEP | Holds file type
 * @subpackage Enumerations
 */
class Type extends AbstractStructEnumBase
{
    /**
     * Constant for value 'LATEST_ARR'
     * @return string 'LATEST_ARR'
     */
    const VALUE_LATEST_ARR = 'LATEST_ARR';
    /**
     * Constant for value 'LATEST_DEP'
     * @return string 'LATEST_DEP'
     */
    const VALUE_LATEST_DEP = 'LATEST_DEP';
    /**
     * Constant for value 'SPAN_SET'
     * @return string 'SPAN_SET'
     */
    const VALUE_SPAN_SET = 'SPAN_SET';
    /**
     * Constant for value 'ANTI_SKID_MAT'
     * @return string 'ANTI_SKID_MAT'
     */
    const VALUE_ANTI_SKID_MAT = 'ANTI_SKID_MAT';
    /**
     * Constant for value 'LASHING_CHAIN'
     * @return string 'LASHING_CHAIN'
     */
    const VALUE_LASHING_CHAIN = 'LASHING_CHAIN';
    /**
     * Constant for value 'CLIPBOARD'
     * @return string 'CLIPBOARD'
     */
    const VALUE_CLIPBOARD = 'CLIPBOARD';
    /**
     * Constant for value 'EDGE_PROTECTOR'
     * @return string 'EDGE_PROTECTOR'
     */
    const VALUE_EDGE_PROTECTOR = 'EDGE_PROTECTOR';
    /**
     * Return allowed values
     * @uses self::VALUE_LATEST_ARR
     * @uses self::VALUE_LATEST_DEP
     * @uses self::VALUE_SPAN_SET
     * @uses self::VALUE_ANTI_SKID_MAT
     * @uses self::VALUE_LASHING_CHAIN
     * @uses self::VALUE_CLIPBOARD
     * @uses self::VALUE_EDGE_PROTECTOR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LATEST_ARR,
            self::VALUE_LATEST_DEP,
            self::VALUE_SPAN_SET,
            self::VALUE_ANTI_SKID_MAT,
            self::VALUE_LASHING_CHAIN,
            self::VALUE_CLIPBOARD,
            self::VALUE_EDGE_PROTECTOR,
        );
    }
}
