<?php

namespace DBSchenker\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for serviceAirType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Defines the service type like door2door(D2D), airport2airport(A2A)...
 * @subpackage Enumerations
 */
class ServiceAirType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'D2D'
     * @return string 'D2D'
     */
    const VALUE_D_2_D = 'D2D';
    /**
     * Constant for value 'D2A'
     * @return string 'D2A'
     */
    const VALUE_D_2_A = 'D2A';
    /**
     * Constant for value 'A2D'
     * @return string 'A2D'
     */
    const VALUE_A_2_D = 'A2D';
    /**
     * Constant for value 'A2A'
     * @return string 'A2A'
     */
    const VALUE_A_2_A = 'A2A';
    /**
     * Return allowed values
     * @uses self::VALUE_D_2_D
     * @uses self::VALUE_D_2_A
     * @uses self::VALUE_A_2_D
     * @uses self::VALUE_A_2_A
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_D_2_D,
            self::VALUE_D_2_A,
            self::VALUE_A_2_D,
            self::VALUE_A_2_A,
        );
    }
}
