<?php

namespace DBSchenker\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for measureUnitType EnumType
 * Meta information extracted from the WSDL
 * - documentation: valid values : cargoDesc, LOADING_METERS, PIECES, PALLET_SPACE
 * @subpackage Enumerations
 */
class MeasureUnitType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'VOLUME'
     * @return string 'VOLUME'
     */
    const VALUE_VOLUME = 'VOLUME';
    /**
     * Constant for value 'LOADING_METERS'
     * @return string 'LOADING_METERS'
     */
    const VALUE_LOADING_METERS = 'LOADING_METERS';
    /**
     * Constant for value 'PIECES'
     * @return string 'PIECES'
     */
    const VALUE_PIECES = 'PIECES';
    /**
     * Constant for value 'PALLET_SPACE'
     * @return string 'PALLET_SPACE'
     */
    const VALUE_PALLET_SPACE = 'PALLET_SPACE';
    /**
     * Return allowed values
     * @uses self::VALUE_VOLUME
     * @uses self::VALUE_LOADING_METERS
     * @uses self::VALUE_PIECES
     * @uses self::VALUE_PALLET_SPACE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_VOLUME,
            self::VALUE_LOADING_METERS,
            self::VALUE_PIECES,
            self::VALUE_PALLET_SPACE,
        );
    }
}
