<?php

namespace DBSchenker\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for longGoodsType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Long goods specification. TYPE_1: Long goods from 2.40 m to 3.00 m - TYPE_2: Long goods from 3.00 m to 6.00 m
 * @subpackage Enumerations
 */
class LongGoodsType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'TYPE_1'
     * @return string 'TYPE_1'
     */
    const VALUE_TYPE_1 = 'TYPE_1';
    /**
     * Constant for value 'TYPE_2'
     * @return string 'TYPE_2'
     */
    const VALUE_TYPE_2 = 'TYPE_2';
    /**
     * Return allowed values
     * @uses self::VALUE_TYPE_1
     * @uses self::VALUE_TYPE_2
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TYPE_1,
            self::VALUE_TYPE_2,
        );
    }
}
