<?php

namespace DBSchenker\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for liftingPlatform EnumType
 * Meta information extracted from the WSDL
 * - documentation: Defines if shipment has Tail lift platform at pickup and/or delivery
 * @subpackage Enumerations
 */
class LiftingPlatform extends AbstractStructEnumBase
{
    /**
     * Constant for value 'LIFTING_PLATFORM_PICKUP'
     * @return string 'LIFTING_PLATFORM_PICKUP'
     */
    const VALUE_LIFTING_PLATFORM_PICKUP = 'LIFTING_PLATFORM_PICKUP';
    /**
     * Constant for value 'LIFTING_PLATFORM_DELIVERY'
     * @return string 'LIFTING_PLATFORM_DELIVERY'
     */
    const VALUE_LIFTING_PLATFORM_DELIVERY = 'LIFTING_PLATFORM_DELIVERY';
    /**
     * Return allowed values
     * @uses self::VALUE_LIFTING_PLATFORM_PICKUP
     * @uses self::VALUE_LIFTING_PLATFORM_DELIVERY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LIFTING_PLATFORM_PICKUP,
            self::VALUE_LIFTING_PLATFORM_DELIVERY,
        );
    }
}
