<?php

namespace DBSchenker\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for formatType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Defines format type
 * @subpackage Enumerations
 */
class FormatType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'STANDARD_SIZE'
     * @return string 'STANDARD_SIZE'
     */
    const VALUE_STANDARD_SIZE = 'STANDARD_SIZE';
    /**
     * Constant for value 'MEGA_TRAILER'
     * @return string 'MEGA_TRAILER'
     */
    const VALUE_MEGA_TRAILER = 'MEGA_TRAILER';
    /**
     * Constant for value 'JUMBO'
     * @return string 'JUMBO'
     */
    const VALUE_JUMBO = 'JUMBO';
    /**
     * Return allowed values
     * @uses self::VALUE_STANDARD_SIZE
     * @uses self::VALUE_MEGA_TRAILER
     * @uses self::VALUE_JUMBO
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_STANDARD_SIZE,
            self::VALUE_MEGA_TRAILER,
            self::VALUE_JUMBO,
        );
    }
}
