<?php

namespace DBSchenker\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for fileTypeOfDocumentType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Document Types enum
 * @subpackage Enumerations
 */
class FileTypeOfDocumentType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Phytosanitarian Certificate'
     * @return string 'Phytosanitarian Certificate'
     */
    const VALUE_PHYTOSANITARIAN_CERTIFICATE = 'Phytosanitarian Certificate';
    /**
     * Constant for value 'ATA Carnet'
     * @return string 'ATA Carnet'
     */
    const VALUE_ATA_CARNET = 'ATA Carnet';
    /**
     * Constant for value 'Certificate of Origin'
     * @return string 'Certificate of Origin'
     */
    const VALUE_CERTIFICATE_OF_ORIGIN = 'Certificate of Origin';
    /**
     * Constant for value 'CMR Document'
     * @return string 'CMR Document'
     */
    const VALUE_CMR_DOCUMENT = 'CMR Document';
    /**
     * Constant for value 'Commercial Invoice'
     * @return string 'Commercial Invoice'
     */
    const VALUE_COMMERCIAL_INVOICE = 'Commercial Invoice';
    /**
     * Constant for value 'Excise Document'
     * @return string 'Excise Document'
     */
    const VALUE_EXCISE_DOCUMENT = 'Excise Document';
    /**
     * Constant for value 'Goods Certificates'
     * @return string 'Goods Certificates'
     */
    const VALUE_GOODS_CERTIFICATES = 'Goods Certificates';
    /**
     * Constant for value 'Import Customs Document'
     * @return string 'Import Customs Document'
     */
    const VALUE_IMPORT_CUSTOMS_DOCUMENT = 'Import Customs Document';
    /**
     * Constant for value 'Licenses and Permits'
     * @return string 'Licenses and Permits'
     */
    const VALUE_LICENSES_AND_PERMITS = 'Licenses and Permits';
    /**
     * Constant for value 'Customer Delivery Note'
     * @return string 'Customer Delivery Note'
     */
    const VALUE_CUSTOMER_DELIVERY_NOTE = 'Customer Delivery Note';
    /**
     * Constant for value 'Dangerous Goods Documents'
     * @return string 'Dangerous Goods Documents'
     */
    const VALUE_DANGEROUS_GOODS_DOCUMENTS = 'Dangerous Goods Documents';
    /**
     * Constant for value 'Export Customs Declaration'
     * @return string 'Export Customs Declaration'
     */
    const VALUE_EXPORT_CUSTOMS_DECLARATION = 'Export Customs Declaration';
    /**
     * Constant for value 'Loading Device Document'
     * @return string 'Loading Device Document'
     */
    const VALUE_LOADING_DEVICE_DOCUMENT = 'Loading Device Document';
    /**
     * Constant for value 'Others'
     * @return string 'Others'
     */
    const VALUE_OTHERS = 'Others';
    /**
     * Constant for value 'Packing List'
     * @return string 'Packing List'
     */
    const VALUE_PACKING_LIST = 'Packing List';
    /**
     * Constant for value 'Customs Preference Document'
     * @return string 'Customs Preference Document'
     */
    const VALUE_CUSTOMS_PREFERENCE_DOCUMENT = 'Customs Preference Document';
    /**
     * Constant for value 'Price Quotation'
     * @return string 'Price Quotation'
     */
    const VALUE_PRICE_QUOTATION = 'Price Quotation';
    /**
     * Constant for value 'Export Declaration'
     * @return string 'Export Declaration'
     */
    const VALUE_EXPORT_DECLARATION = 'Export Declaration';
    /**
     * Constant for value 'Transit Customs Document'
     * @return string 'Transit Customs Document'
     */
    const VALUE_TRANSIT_CUSTOMS_DOCUMENT = 'Transit Customs Document';
    /**
     * Return allowed values
     * @uses self::VALUE_PHYTOSANITARIAN_CERTIFICATE
     * @uses self::VALUE_ATA_CARNET
     * @uses self::VALUE_CERTIFICATE_OF_ORIGIN
     * @uses self::VALUE_CMR_DOCUMENT
     * @uses self::VALUE_COMMERCIAL_INVOICE
     * @uses self::VALUE_EXCISE_DOCUMENT
     * @uses self::VALUE_GOODS_CERTIFICATES
     * @uses self::VALUE_IMPORT_CUSTOMS_DOCUMENT
     * @uses self::VALUE_LICENSES_AND_PERMITS
     * @uses self::VALUE_CUSTOMER_DELIVERY_NOTE
     * @uses self::VALUE_DANGEROUS_GOODS_DOCUMENTS
     * @uses self::VALUE_EXPORT_CUSTOMS_DECLARATION
     * @uses self::VALUE_LOADING_DEVICE_DOCUMENT
     * @uses self::VALUE_OTHERS
     * @uses self::VALUE_PACKING_LIST
     * @uses self::VALUE_CUSTOMS_PREFERENCE_DOCUMENT
     * @uses self::VALUE_PRICE_QUOTATION
     * @uses self::VALUE_EXPORT_DECLARATION
     * @uses self::VALUE_TRANSIT_CUSTOMS_DOCUMENT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PHYTOSANITARIAN_CERTIFICATE,
            self::VALUE_ATA_CARNET,
            self::VALUE_CERTIFICATE_OF_ORIGIN,
            self::VALUE_CMR_DOCUMENT,
            self::VALUE_COMMERCIAL_INVOICE,
            self::VALUE_EXCISE_DOCUMENT,
            self::VALUE_GOODS_CERTIFICATES,
            self::VALUE_IMPORT_CUSTOMS_DOCUMENT,
            self::VALUE_LICENSES_AND_PERMITS,
            self::VALUE_CUSTOMER_DELIVERY_NOTE,
            self::VALUE_DANGEROUS_GOODS_DOCUMENTS,
            self::VALUE_EXPORT_CUSTOMS_DECLARATION,
            self::VALUE_LOADING_DEVICE_DOCUMENT,
            self::VALUE_OTHERS,
            self::VALUE_PACKING_LIST,
            self::VALUE_CUSTOMS_PREFERENCE_DOCUMENT,
            self::VALUE_PRICE_QUOTATION,
            self::VALUE_EXPORT_DECLARATION,
            self::VALUE_TRANSIT_CUSTOMS_DOCUMENT,
        );
    }
}
