<?php

namespace DBSchenker\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for addressDirectionType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Defines the type of address like SHIPPER, CONSIGNEE, PICKUP, DELIVERY, NOTIFY, INVOICE, POS_PICKUP_OCEAN, POS_CONTAINER
 * @subpackage Enumerations
 */
class AddressDirectionType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'SHIPPER'
     * @return string 'SHIPPER'
     */
    const VALUE_SHIPPER = 'SHIPPER';
    /**
     * Constant for value 'CONSIGNEE'
     * @return string 'CONSIGNEE'
     */
    const VALUE_CONSIGNEE = 'CONSIGNEE';
    /**
     * Constant for value 'PICKUP'
     * @return string 'PICKUP'
     */
    const VALUE_PICKUP = 'PICKUP';
    /**
     * Constant for value 'DELIVERY'
     * @return string 'DELIVERY'
     */
    const VALUE_DELIVERY = 'DELIVERY';
    /**
     * Constant for value 'NOTIFY'
     * @return string 'NOTIFY'
     */
    const VALUE_NOTIFY = 'NOTIFY';
    /**
     * Constant for value 'INVOICE'
     * @return string 'INVOICE'
     */
    const VALUE_INVOICE = 'INVOICE';
    /**
     * Constant for value 'POS_PICKUP_OCEAN'
     * @return string 'POS_PICKUP_OCEAN'
     */
    const VALUE_POS_PICKUP_OCEAN = 'POS_PICKUP_OCEAN';
    /**
     * Constant for value 'POS_CONTAINER'
     * @return string 'POS_CONTAINER'
     */
    const VALUE_POS_CONTAINER = 'POS_CONTAINER';
    /**
     * Return allowed values
     * @uses self::VALUE_SHIPPER
     * @uses self::VALUE_CONSIGNEE
     * @uses self::VALUE_PICKUP
     * @uses self::VALUE_DELIVERY
     * @uses self::VALUE_NOTIFY
     * @uses self::VALUE_INVOICE
     * @uses self::VALUE_POS_PICKUP_OCEAN
     * @uses self::VALUE_POS_CONTAINER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SHIPPER,
            self::VALUE_CONSIGNEE,
            self::VALUE_PICKUP,
            self::VALUE_DELIVERY,
            self::VALUE_NOTIFY,
            self::VALUE_INVOICE,
            self::VALUE_POS_PICKUP_OCEAN,
            self::VALUE_POS_CONTAINER,
        );
    }
}
