<?php

namespace DBSchenker;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'bookingType' => '\\DBSchenker\\StructType\\BookingType',
            'barcodeRequest' => '\\DBSchenker\\StructType\\BarcodeRequest',
            'bookingAirType' => '\\DBSchenker\\StructType\\BookingAirType',
            'bookingOceanLCLType' => '\\DBSchenker\\StructType\\BookingOceanLCLType',
            'bookingOceanFCLType' => '\\DBSchenker\\StructType\\BookingOceanFCLType',
            'bookingLandType' => '\\DBSchenker\\StructType\\BookingLandType',
            'addressType' => '\\DBSchenker\\StructType\\AddressType',
            'contactPersonType' => '\\DBSchenker\\StructType\\ContactPersonType',
            'currency' => '\\DBSchenker\\StructType\\Currency',
            'containerType' => '\\DBSchenker\\StructType\\ContainerType',
            'shippingInformationType' => '\\DBSchenker\\StructType\\ShippingInformationType',
            'shipmentPositionType' => '\\DBSchenker\\StructType\\ShipmentPositionType',
            'dangerousGoodsType' => '\\DBSchenker\\StructType\\DangerousGoodsType',
            'dangerousGoodsUnNoType' => '\\DBSchenker\\StructType\\DangerousGoodsUnNoType',
            'packageLineType' => '\\DBSchenker\\StructType\\PackageLineType',
            'customsDeclarant' => '\\DBSchenker\\StructType\\CustomsDeclarant',
            'declarantInformation' => '\\DBSchenker\\StructType\\DeclarantInformation',
            'fileType' => '\\DBSchenker\\StructType\\FileType',
            'applicationAreaRequest' => '\\DBSchenker\\StructType\\ApplicationAreaRequest',
            'temperature' => '\\DBSchenker\\StructType\\Temperature',
            'returnPallet' => '\\DBSchenker\\StructType\\ReturnPallet',
            'loadingDevice' => '\\DBSchenker\\StructType\\LoadingDevice',
            'format' => '\\DBSchenker\\StructType\\Format',
            'pickupDate' => '\\DBSchenker\\StructType\\PickupDate',
            'preAdvise' => '\\DBSchenker\\StructType\\PreAdvise',
            'deliveryDateConsignee' => '\\DBSchenker\\StructType\\DeliveryDateConsignee',
            'reference' => '\\DBSchenker\\StructType\\Reference',
            'barcodeReferenceType' => '\\DBSchenker\\StructType\\BarcodeReferenceType',
            'vesselDateType' => '\\DBSchenker\\StructType\\VesselDateType',
            'loadSecuringEquipmentType' => '\\DBSchenker\\StructType\\LoadSecuringEquipmentType',
            'landEquipmentType' => '\\DBSchenker\\StructType\\LandEquipmentType',
            'sentApplicable' => '\\DBSchenker\\StructType\\SentApplicable',
            'preNoticeContactType' => '\\DBSchenker\\StructType\\PreNoticeContactType',
            'deliveryPreNoticeSmsType' => '\\DBSchenker\\StructType\\DeliveryPreNoticeSmsType',
            'deliveryPreNoticeEmailType' => '\\DBSchenker\\StructType\\DeliveryPreNoticeEmailType',
            'externalBookingRequest' => '\\DBSchenker\\StructType\\ExternalBookingRequest',
            'getBookingRequestLand' => '\\DBSchenker\\StructType\\GetBookingRequestLand',
            'externalBookingRequestLand' => '\\DBSchenker\\StructType\\ExternalBookingRequestLand',
            'getBookingRequestAir' => '\\DBSchenker\\StructType\\GetBookingRequestAir',
            'externalBookingRequestAir' => '\\DBSchenker\\StructType\\ExternalBookingRequestAir',
            'getBookingOceanLCL' => '\\DBSchenker\\StructType\\GetBookingOceanLCL',
            'externalBookingRequestOceanLCL' => '\\DBSchenker\\StructType\\ExternalBookingRequestOceanLCL',
            'getBookingOceanFCL' => '\\DBSchenker\\StructType\\GetBookingOceanFCL',
            'externalBookingRequestOceanFCL' => '\\DBSchenker\\StructType\\ExternalBookingRequestOceanFCL',
            'getCancelRequest' => '\\DBSchenker\\StructType\\GetCancelRequest',
            'externalCancelRequest' => '\\DBSchenker\\StructType\\ExternalCancelRequest',
            'cancelRequestType' => '\\DBSchenker\\StructType\\CancelRequestType',
            'getBarcodeRequest' => '\\DBSchenker\\StructType\\GetBarcodeRequest',
            'externalBarcodeRequest' => '\\DBSchenker\\StructType\\ExternalBarcodeRequest',
            'barcodeRequestType' => '\\DBSchenker\\StructType\\BarcodeRequestType',
            'barcodeRequestEmailType' => '\\DBSchenker\\StructType\\BarcodeRequestEmailType',
            'getBarcodeResponse' => '\\DBSchenker\\StructType\\GetBarcodeResponse',
            'externalBarcodeResponse' => '\\DBSchenker\\StructType\\ExternalBarcodeResponse',
            'getCancelResponse' => '\\DBSchenker\\StructType\\GetCancelResponse',
            'externalCancelResponse' => '\\DBSchenker\\StructType\\ExternalCancelResponse',
            'getBookingResponse' => '\\DBSchenker\\StructType\\GetBookingResponse',
            'externalBookingResponse' => '\\DBSchenker\\StructType\\ExternalBookingResponse',
            'applicationAreaResponse' => '\\DBSchenker\\StructType\\ApplicationAreaResponse',
            'schenkerServiceExceptionError' => '\\DBSchenker\\StructType\\SchenkerServiceExceptionError',
            'schenkerServiceException' => '\\DBSchenker\\StructType\\SchenkerServiceException',
        );
    }
}
