<?php

namespace DBSchenker\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for temperature StructType
 * Meta information extracted from the WSDL
 * - documentation: Holds transport temperature From/To -199/+199
 * @subpackage Structs
 */
class Temperature extends AbstractStructBase
{
    /**
     * The temperatureFrom
     * Meta information extracted from the WSDL
     * - documentation: Holds transport temperature From
     * - minOccurs: 0
     * @var int
     */
    public $temperatureFrom;
    /**
     * The temperatureTo
     * Meta information extracted from the WSDL
     * - documentation: Holds transport temperature To
     * - minOccurs: 0
     * @var int
     */
    public $temperatureTo;
    /**
     * Constructor method for temperature
     * @uses Temperature::setTemperatureFrom()
     * @uses Temperature::setTemperatureTo()
     * @param int $temperatureFrom
     * @param int $temperatureTo
     */
    public function __construct($temperatureFrom = null, $temperatureTo = null)
    {
        $this
            ->setTemperatureFrom($temperatureFrom)
            ->setTemperatureTo($temperatureTo);
    }
    /**
     * Get temperatureFrom value
     * @return int|null
     */
    public function getTemperatureFrom()
    {
        return $this->temperatureFrom;
    }
    /**
     * Set temperatureFrom value
     * @param int $temperatureFrom
     * @return \DBSchenker\StructType\Temperature
     */
    public function setTemperatureFrom($temperatureFrom = null)
    {
        // validation for constraint: int
        if (!is_null($temperatureFrom) && !(is_int($temperatureFrom) || ctype_digit($temperatureFrom))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($temperatureFrom, true), gettype($temperatureFrom)), __LINE__);
        }
        $this->temperatureFrom = $temperatureFrom;
        return $this;
    }
    /**
     * Get temperatureTo value
     * @return int|null
     */
    public function getTemperatureTo()
    {
        return $this->temperatureTo;
    }
    /**
     * Set temperatureTo value
     * @param int $temperatureTo
     * @return \DBSchenker\StructType\Temperature
     */
    public function setTemperatureTo($temperatureTo = null)
    {
        // validation for constraint: int
        if (!is_null($temperatureTo) && !(is_int($temperatureTo) || ctype_digit($temperatureTo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($temperatureTo, true), gettype($temperatureTo)), __LINE__);
        }
        $this->temperatureTo = $temperatureTo;
        return $this;
    }
}
