<?php

namespace DBSchenker\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for format StructType
 * @subpackage Structs
 */
class Format extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The start_pos
     * Meta information extracted from the WSDL
     * - base: xs:positiveInteger
     * - default: 1
     * - maxInclusive: 4
     * - minInclusive: 1
     * @var int
     */
    public $start_pos;
    /**
     * The separated
     * Meta information extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $separated;
    /**
     * The directThermalMedia
     * Meta information extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $directThermalMedia;
    /**
     * Constructor method for format
     * @uses Format::set_()
     * @uses Format::setStart_pos()
     * @uses Format::setSeparated()
     * @uses Format::setDirectThermalMedia()
     * @param string $_
     * @param int $start_pos
     * @param bool $separated
     * @param bool $directThermalMedia
     */
    public function __construct($_ = null, $start_pos = 1, $separated = false, $directThermalMedia = false)
    {
        $this
            ->set_($_)
            ->setStart_pos($start_pos)
            ->setSeparated($separated)
            ->setDirectThermalMedia($directThermalMedia);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \DBSchenker\StructType\Format
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get start_pos value
     * @return int|null
     */
    public function getStart_pos()
    {
        return $this->start_pos;
    }
    /**
     * Set start_pos value
     * @param int $start_pos
     * @return \DBSchenker\StructType\Format
     */
    public function setStart_pos($start_pos = 1)
    {
        // validation for constraint: int
        if (!is_null($start_pos) && !(is_int($start_pos) || ctype_digit($start_pos))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($start_pos, true), gettype($start_pos)), __LINE__);
        }
        // validation for constraint: maxInclusive(4)
        if (!is_null($start_pos) && $start_pos > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 4', var_export($start_pos, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($start_pos) && $start_pos < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($start_pos, true)), __LINE__);
        }
        $this->start_pos = $start_pos;
        return $this;
    }
    /**
     * Get separated value
     * @return bool|null
     */
    public function getSeparated()
    {
        return $this->separated;
    }
    /**
     * Set separated value
     * @param bool $separated
     * @return \DBSchenker\StructType\Format
     */
    public function setSeparated($separated = false)
    {
        // validation for constraint: boolean
        if (!is_null($separated) && !is_bool($separated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($separated, true), gettype($separated)), __LINE__);
        }
        $this->separated = $separated;
        return $this;
    }
    /**
     * Get directThermalMedia value
     * @return bool|null
     */
    public function getDirectThermalMedia()
    {
        return $this->directThermalMedia;
    }
    /**
     * Set directThermalMedia value
     * @param bool $directThermalMedia
     * @return \DBSchenker\StructType\Format
     */
    public function setDirectThermalMedia($directThermalMedia = false)
    {
        // validation for constraint: boolean
        if (!is_null($directThermalMedia) && !is_bool($directThermalMedia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($directThermalMedia, true), gettype($directThermalMedia)), __LINE__);
        }
        $this->directThermalMedia = $directThermalMedia;
        return $this;
    }
}
