<?php

namespace DBSchenker\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for externalCancelResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: Holds Cancel Response
 * @subpackage Structs
 */
class ExternalCancelResponse extends AbstractStructBase
{
    /**
     * The applicationArea
     * Meta information extracted from the WSDL
     * - documentation: Holds access request ID of the request, which will be returned with response
     * - minOccurs: 1
     * @var \DBSchenker\StructType\ApplicationAreaResponse
     */
    public $applicationArea;
    /**
     * The bookingId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [\d]{6}-[\d]{6}
     * @var string
     */
    public $bookingId;
    /**
     * Constructor method for externalCancelResponse
     * @uses ExternalCancelResponse::setApplicationArea()
     * @uses ExternalCancelResponse::setBookingId()
     * @param \DBSchenker\StructType\ApplicationAreaResponse $applicationArea
     * @param string $bookingId
     */
    public function __construct(\DBSchenker\StructType\ApplicationAreaResponse $applicationArea = null, $bookingId = null)
    {
        $this
            ->setApplicationArea($applicationArea)
            ->setBookingId($bookingId);
    }
    /**
     * Get applicationArea value
     * @return \DBSchenker\StructType\ApplicationAreaResponse
     */
    public function getApplicationArea()
    {
        return $this->applicationArea;
    }
    /**
     * Set applicationArea value
     * @param \DBSchenker\StructType\ApplicationAreaResponse $applicationArea
     * @return \DBSchenker\StructType\ExternalCancelResponse
     */
    public function setApplicationArea(\DBSchenker\StructType\ApplicationAreaResponse $applicationArea = null)
    {
        $this->applicationArea = $applicationArea;
        return $this;
    }
    /**
     * Get bookingId value
     * @return string
     */
    public function getBookingId()
    {
        return $this->bookingId;
    }
    /**
     * Set bookingId value
     * @param string $bookingId
     * @return \DBSchenker\StructType\ExternalCancelResponse
     */
    public function setBookingId($bookingId = null)
    {
        // validation for constraint: string
        if (!is_null($bookingId) && !is_string($bookingId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingId, true), gettype($bookingId)), __LINE__);
        }
        // validation for constraint: pattern([\d]{6}-[\d]{6})
        if (!is_null($bookingId) && !preg_match('/[\\d]{6}-[\\d]{6}/', $bookingId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\d]{6}-[\d]{6}', var_export($bookingId, true)), __LINE__);
        }
        $this->bookingId = $bookingId;
        return $this;
    }
}
