<?php

namespace DBSchenker\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for deliveryPreNoticeEmailType StructType
 * Meta information extracted from the WSDL
 * - documentation: Holds delivery pre-notice email information.
 * @subpackage Structs
 */
class DeliveryPreNoticeEmailType extends AbstractStructBase
{
    /**
     * The contact
     * Meta information extracted from the WSDL
     * - documentation: Defines contact | The contact person's name.
     * - base: xs:string
     * - maxLength: 500
     * @var string
     */
    public $contact;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - documentation: Defines email address | Defines email of contact person | Defines email | The contact person's email address.
     * - base: xs:string
     * - maxLength: 250
     * - pattern: [^@]+@[^\.]+\..+
     * @var string
     */
    public $email;
    /**
     * Constructor method for deliveryPreNoticeEmailType
     * @uses DeliveryPreNoticeEmailType::setContact()
     * @uses DeliveryPreNoticeEmailType::setEmail()
     * @param string $contact
     * @param string $email
     */
    public function __construct($contact = null, $email = null)
    {
        $this
            ->setContact($contact)
            ->setEmail($email);
    }
    /**
     * Get contact value
     * @return string|null
     */
    public function getContact()
    {
        return $this->contact;
    }
    /**
     * Set contact value
     * @param string $contact
     * @return \DBSchenker\StructType\DeliveryPreNoticeEmailType
     */
    public function setContact($contact = null)
    {
        // validation for constraint: string
        if (!is_null($contact) && !is_string($contact)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contact, true), gettype($contact)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($contact) && mb_strlen($contact) > 500) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen($contact)), __LINE__);
        }
        $this->contact = $contact;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \DBSchenker\StructType\DeliveryPreNoticeEmailType
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        // validation for constraint: maxLength(250)
        if (!is_null($email) && mb_strlen($email) > 250) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 250', mb_strlen($email)), __LINE__);
        }
        // validation for constraint: pattern([^@]+@[^\.]+\..+)
        if (!is_null($email) && !preg_match('/[^@]+@[^\\.]+\\..+/', $email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [^@]+@[^\.]+\..+', var_export($email, true)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
}
