<?php

namespace DBSchenker\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for barcodeRequestEmailType StructType
 * Meta information extracted from the WSDL
 * - documentation: Sends barcode labels to defined email addresses
 * @subpackage Structs
 */
class BarcodeRequestEmailType extends AbstractStructBase
{
    /**
     * The email
     * Meta information extracted from the WSDL
     * - documentation: Defines email address | Defines email of contact person | Defines email | The contact person's email address.
     * - base: xs:string
     * - maxLength: 250
     * - maxOccurs: 25
     * - minOccurs: 1
     * - pattern: [^@]+@[^\.]+\..+
     * @var string[]
     */
    public $email;
    /**
     * Constructor method for barcodeRequestEmailType
     * @uses BarcodeRequestEmailType::setEmail()
     * @param string[] $email
     */
    public function __construct(array $email = array())
    {
        $this
            ->setEmail($email);
    }
    /**
     * Get email value
     * @return string[]
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * This method is responsible for validating the values passed to the setEmail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmailForArrayConstraintsFromSetEmail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $barcodeRequestEmailTypeEmailItem) {
            // validation for constraint: itemType
            if (!is_string($barcodeRequestEmailTypeEmailItem)) {
                $invalidValues[] = is_object($barcodeRequestEmailTypeEmailItem) ? get_class($barcodeRequestEmailTypeEmailItem) : sprintf('%s(%s)', gettype($barcodeRequestEmailTypeEmailItem), var_export($barcodeRequestEmailTypeEmailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The email property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setEmail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmail method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmailForMaxLengthConstraintFromSetEmail($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $barcodeRequestEmailTypeEmailItem) {
            // validation for constraint: maxLength(250)
            if (mb_strlen($barcodeRequestEmailTypeEmailItem) > 250) {
                $invalidValues[] = var_export($barcodeRequestEmailTypeEmailItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be less than or equal to 250', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set email value
     * @throws \InvalidArgumentException
     * @param string[] $email
     * @return \DBSchenker\StructType\BarcodeRequestEmailType
     */
    public function setEmail(array $email = array())
    {
        // validation for constraint: array
        if ('' !== ($emailArrayErrorMessage = self::validateEmailForArrayConstraintsFromSetEmail($email))) {
            throw new \InvalidArgumentException($emailArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(250)
        if ('' !== ($emailMaxLengthErrorMessage = self::validateEmailForMaxLengthConstraintFromSetEmail($email))) {
            throw new \InvalidArgumentException($emailMaxLengthErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(25)
        if (is_array($email) && count($email) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 25', count($email)), __LINE__);
        }
        // validation for constraint: pattern([^@]+@[^\.]+\..+)
        if (!is_null($email) && !preg_match('/[^@]+@[^\\.]+\\..+/', $email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [^@]+@[^\.]+\..+', var_export($email, true)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Add item to email value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \DBSchenker\StructType\BarcodeRequestEmailType
     */
    public function addToEmail($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The email property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxLength(250)
        if (mb_strlen($item) > 250) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 250', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: maxOccurs(25)
        if (is_array($this->email) && count($this->email) >= 25) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 25', count($this->email)), __LINE__);
        }
        // validation for constraint: pattern([^@]+@[^\.]+\..+)
        if (!preg_match('/[^@]+@[^\\.]+\\..+/', $item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [^@]+@[^\.]+\..+', var_export($item, true)), __LINE__);
        }
        $this->email[] = $item;
        return $this;
    }
}
