<?php

namespace DBSchenker\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for addressType StructType
 * Meta information extracted from the WSDL
 * - documentation: Booking Address type
 * @subpackage Structs
 */
class AddressType extends AbstractStructBase
{
    /**
     * The name1
     * Meta information extracted from the WSDL
     * - documentation: Defines name
     * - base: xs:string
     * - maxLength: 500
     * - minOccurs: 1
     * @var string
     */
    public $name1;
    /**
     * The street
     * Meta information extracted from the WSDL
     * - documentation: Defines street information | Defines street
     * - base: xs:string
     * - maxLength: 1000
     * - minOccurs: 1
     * @var string
     */
    public $street;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - documentation: Defines city
     * - base: xs:string
     * - maxLength: 500
     * - minOccurs: 1
     * @var string
     */
    public $city;
    /**
     * The countryCode
     * Meta information extracted from the WSDL
     * - documentation: Defines code of the country | Defines countryCode
     * - base: xs:string
     * - maxLength: 10
     * - minOccurs: 1
     * @var string
     */
    public $countryCode;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - documentation: Specifies address type: SHIPPER, CONSIGNEE, PICKUP, DELIVERY, NOTIFY, INVOICE, POS_PICKUP_OCEAN, POS_CONTAINER
     * - minOccurs: 1
     * @var string
     */
    public $type;
    /**
     * The contactPerson
     * Meta information extracted from the WSDL
     * - documentation: Holds list of contact persons
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \DBSchenker\StructType\ContactPersonType[]
     */
    public $contactPerson;
    /**
     * The name2
     * Meta information extracted from the WSDL
     * - documentation: Defines additional name
     * - base: xs:string
     * - maxLength: 500
     * - minOccurs: 0
     * @var string
     */
    public $name2;
    /**
     * The customerAddressIdentifier
     * Meta information extracted from the WSDL
     * - documentation: Defines customer address identifier
     * - base: xs:string
     * - maxLength: 100
     * - minOccurs: 0
     * @var string
     */
    public $customerAddressIdentifier;
    /**
     * The vatNo
     * Meta information extracted from the WSDL
     * - documentation: Defines customer VAT number
     * - base: xs:string
     * - maxLength: 100
     * - minOccurs: 0
     * @var string
     */
    public $vatNo;
    /**
     * The customsId
     * Meta information extracted from the WSDL
     * - documentation: Defines customs ID
     * - base: xs:string
     * - maxLength: 100
     * - minOccurs: 0
     * @var string
     */
    public $customsId;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - documentation: Defines email address | Defines email of contact person | Defines email | The contact person's email address.
     * - base: xs:string
     * - maxLength: 250
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The fax
     * Meta information extracted from the WSDL
     * - documentation: Defines fax
     * - base: xs:string
     * - maxLength: 250
     * - minOccurs: 0
     * @var string
     */
    public $fax;
    /**
     * The industry
     * Meta information extracted from the WSDL
     * - documentation: Defines industry value
     * - minOccurs: 0
     * @var string
     */
    public $industry;
    /**
     * The locationType
     * Meta information extracted from the WSDL
     * - documentation: Defines location type: POSTAL or PHYSICAL
     * @var string
     */
    public $locationType;
    /**
     * The mobilePhone
     * Meta information extracted from the WSDL
     * - documentation: Defines mobile phone
     * - base: xs:string
     * - maxLength: 250
     * - minOccurs: 0
     * @var string
     */
    public $mobilePhone;
    /**
     * The personType
     * Meta information extracted from the WSDL
     * - documentation: Defines person type: PERSON or COMPANY
     * @var string
     */
    public $personType;
    /**
     * The phone
     * Meta information extracted from the WSDL
     * - documentation: Defines phone | Defines contact phone | The contact person's phone number.
     * - base: xs:string
     * - maxLength: 250
     * - minOccurs: 0
     * @var string
     */
    public $phone;
    /**
     * The poBox
     * Meta information extracted from the WSDL
     * - documentation: Defines PO Box
     * - base: xs:string
     * - maxLength: 50
     * - minOccurs: 0
     * @var string
     */
    public $poBox;
    /**
     * The postalCode
     * Meta information extracted from the WSDL
     * - documentation: Defines postal code | Defines postalCode
     * - base: xs:string
     * - maxLength: 20
     * - minOccurs: 0
     * @var string
     */
    public $postalCode;
    /**
     * The stateCode
     * Meta information extracted from the WSDL
     * - documentation: Defines state code
     * - base: xs:string
     * - maxLength: 5
     * - minOccurs: 0
     * @var string
     */
    public $stateCode;
    /**
     * The stateName
     * Meta information extracted from the WSDL
     * - documentation: Defines state name
     * - base: xs:string
     * - maxLength: 35
     * - minOccurs: 0
     * @var string
     */
    public $stateName;
    /**
     * The preferredLanguage
     * Meta information extracted from the WSDL
     * - documentation: Defines preferred language
     * - base: xs:string
     * - maxLength: 10
     * - minOccurs: 0
     * @var string
     */
    public $preferredLanguage;
    /**
     * The schenkerAddressId
     * Meta information extracted from the WSDL
     * - documentation: Defines Schenker Address Id
     * - base: xs:string
     * - maxLength: 36
     * - minOccurs: 0
     * @var string
     */
    public $schenkerAddressId;
    /**
     * The street2
     * Meta information extracted from the WSDL
     * - documentation: Defines additional street information
     * - base: xs:string
     * - maxLength: 1000
     * - minOccurs: 0
     * @var string
     */
    public $street2;
    /**
     * Constructor method for addressType
     * @uses AddressType::setName1()
     * @uses AddressType::setStreet()
     * @uses AddressType::setCity()
     * @uses AddressType::setCountryCode()
     * @uses AddressType::setType()
     * @uses AddressType::setContactPerson()
     * @uses AddressType::setName2()
     * @uses AddressType::setCustomerAddressIdentifier()
     * @uses AddressType::setVatNo()
     * @uses AddressType::setCustomsId()
     * @uses AddressType::setEmail()
     * @uses AddressType::setFax()
     * @uses AddressType::setIndustry()
     * @uses AddressType::setLocationType()
     * @uses AddressType::setMobilePhone()
     * @uses AddressType::setPersonType()
     * @uses AddressType::setPhone()
     * @uses AddressType::setPoBox()
     * @uses AddressType::setPostalCode()
     * @uses AddressType::setStateCode()
     * @uses AddressType::setStateName()
     * @uses AddressType::setPreferredLanguage()
     * @uses AddressType::setSchenkerAddressId()
     * @uses AddressType::setStreet2()
     * @param string $name1
     * @param string $street
     * @param string $city
     * @param string $countryCode
     * @param string $type
     * @param \DBSchenker\StructType\ContactPersonType[] $contactPerson
     * @param string $name2
     * @param string $customerAddressIdentifier
     * @param string $vatNo
     * @param string $customsId
     * @param string $email
     * @param string $fax
     * @param string $industry
     * @param string $locationType
     * @param string $mobilePhone
     * @param string $personType
     * @param string $phone
     * @param string $poBox
     * @param string $postalCode
     * @param string $stateCode
     * @param string $stateName
     * @param string $preferredLanguage
     * @param string $schenkerAddressId
     * @param string $street2
     */
    public function __construct($name1 = null, $street = null, $city = null, $countryCode = null, $type = null, array $contactPerson = array(), $name2 = null, $customerAddressIdentifier = null, $vatNo = null, $customsId = null, $email = null, $fax = null, $industry = null, $locationType = null, $mobilePhone = null, $personType = null, $phone = null, $poBox = null, $postalCode = null, $stateCode = null, $stateName = null, $preferredLanguage = null, $schenkerAddressId = null, $street2 = null)
    {
        $this
            ->setName1($name1)
            ->setStreet($street)
            ->setCity($city)
            ->setCountryCode($countryCode)
            ->setType($type)
            ->setContactPerson($contactPerson)
            ->setName2($name2)
            ->setCustomerAddressIdentifier($customerAddressIdentifier)
            ->setVatNo($vatNo)
            ->setCustomsId($customsId)
            ->setEmail($email)
            ->setFax($fax)
            ->setIndustry($industry)
            ->setLocationType($locationType)
            ->setMobilePhone($mobilePhone)
            ->setPersonType($personType)
            ->setPhone($phone)
            ->setPoBox($poBox)
            ->setPostalCode($postalCode)
            ->setStateCode($stateCode)
            ->setStateName($stateName)
            ->setPreferredLanguage($preferredLanguage)
            ->setSchenkerAddressId($schenkerAddressId)
            ->setStreet2($street2);
    }
    /**
     * Get name1 value
     * @return string
     */
    public function getName1()
    {
        return $this->name1;
    }
    /**
     * Set name1 value
     * @param string $name1
     * @return \DBSchenker\StructType\AddressType
     */
    public function setName1($name1 = null)
    {
        // validation for constraint: string
        if (!is_null($name1) && !is_string($name1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name1, true), gettype($name1)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($name1) && mb_strlen($name1) > 500) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen($name1)), __LINE__);
        }
        $this->name1 = $name1;
        return $this;
    }
    /**
     * Get street value
     * @return string
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param string $street
     * @return \DBSchenker\StructType\AddressType
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        // validation for constraint: maxLength(1000)
        if (!is_null($street) && mb_strlen($street) > 1000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1000', mb_strlen($street)), __LINE__);
        }
        $this->street = $street;
        return $this;
    }
    /**
     * Get city value
     * @return string
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \DBSchenker\StructType\AddressType
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($city) && mb_strlen($city) > 500) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get countryCode value
     * @return string
     */
    public function getCountryCode()
    {
        return $this->countryCode;
    }
    /**
     * Set countryCode value
     * @param string $countryCode
     * @return \DBSchenker\StructType\AddressType
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($countryCode) && mb_strlen($countryCode) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($countryCode)), __LINE__);
        }
        $this->countryCode = $countryCode;
        return $this;
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \DBSchenker\EnumType\AddressDirectionType::valueIsValid()
     * @uses \DBSchenker\EnumType\AddressDirectionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \DBSchenker\StructType\AddressType
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\DBSchenker\EnumType\AddressDirectionType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DBSchenker\EnumType\AddressDirectionType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \DBSchenker\EnumType\AddressDirectionType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get contactPerson value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \DBSchenker\StructType\ContactPersonType[]|null
     */
    public function getContactPerson()
    {
        return isset($this->contactPerson) ? $this->contactPerson : null;
    }
    /**
     * This method is responsible for validating the values passed to the setContactPerson method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContactPerson method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactPersonForArrayConstraintsFromSetContactPerson(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $addressTypeContactPersonItem) {
            // validation for constraint: itemType
            if (!$addressTypeContactPersonItem instanceof \DBSchenker\StructType\ContactPersonType) {
                $invalidValues[] = is_object($addressTypeContactPersonItem) ? get_class($addressTypeContactPersonItem) : sprintf('%s(%s)', gettype($addressTypeContactPersonItem), var_export($addressTypeContactPersonItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The contactPerson property can only contain items of type \DBSchenker\StructType\ContactPersonType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set contactPerson value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \DBSchenker\StructType\ContactPersonType[] $contactPerson
     * @return \DBSchenker\StructType\AddressType
     */
    public function setContactPerson(array $contactPerson = array())
    {
        // validation for constraint: array
        if ('' !== ($contactPersonArrayErrorMessage = self::validateContactPersonForArrayConstraintsFromSetContactPerson($contactPerson))) {
            throw new \InvalidArgumentException($contactPersonArrayErrorMessage, __LINE__);
        }
        if (is_null($contactPerson) || (is_array($contactPerson) && empty($contactPerson))) {
            unset($this->contactPerson);
        } else {
            $this->contactPerson = $contactPerson;
        }
        return $this;
    }
    /**
     * Add item to contactPerson value
     * @throws \InvalidArgumentException
     * @param \DBSchenker\StructType\ContactPersonType $item
     * @return \DBSchenker\StructType\AddressType
     */
    public function addToContactPerson(\DBSchenker\StructType\ContactPersonType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \DBSchenker\StructType\ContactPersonType) {
            throw new \InvalidArgumentException(sprintf('The contactPerson property can only contain items of type \DBSchenker\StructType\ContactPersonType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->contactPerson[] = $item;
        return $this;
    }
    /**
     * Get name2 value
     * @return string|null
     */
    public function getName2()
    {
        return $this->name2;
    }
    /**
     * Set name2 value
     * @param string $name2
     * @return \DBSchenker\StructType\AddressType
     */
    public function setName2($name2 = null)
    {
        // validation for constraint: string
        if (!is_null($name2) && !is_string($name2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name2, true), gettype($name2)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($name2) && mb_strlen($name2) > 500) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen($name2)), __LINE__);
        }
        $this->name2 = $name2;
        return $this;
    }
    /**
     * Get customerAddressIdentifier value
     * @return string|null
     */
    public function getCustomerAddressIdentifier()
    {
        return $this->customerAddressIdentifier;
    }
    /**
     * Set customerAddressIdentifier value
     * @param string $customerAddressIdentifier
     * @return \DBSchenker\StructType\AddressType
     */
    public function setCustomerAddressIdentifier($customerAddressIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($customerAddressIdentifier) && !is_string($customerAddressIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerAddressIdentifier, true), gettype($customerAddressIdentifier)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($customerAddressIdentifier) && mb_strlen($customerAddressIdentifier) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($customerAddressIdentifier)), __LINE__);
        }
        $this->customerAddressIdentifier = $customerAddressIdentifier;
        return $this;
    }
    /**
     * Get vatNo value
     * @return string|null
     */
    public function getVatNo()
    {
        return $this->vatNo;
    }
    /**
     * Set vatNo value
     * @param string $vatNo
     * @return \DBSchenker\StructType\AddressType
     */
    public function setVatNo($vatNo = null)
    {
        // validation for constraint: string
        if (!is_null($vatNo) && !is_string($vatNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vatNo, true), gettype($vatNo)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($vatNo) && mb_strlen($vatNo) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($vatNo)), __LINE__);
        }
        $this->vatNo = $vatNo;
        return $this;
    }
    /**
     * Get customsId value
     * @return string|null
     */
    public function getCustomsId()
    {
        return $this->customsId;
    }
    /**
     * Set customsId value
     * @param string $customsId
     * @return \DBSchenker\StructType\AddressType
     */
    public function setCustomsId($customsId = null)
    {
        // validation for constraint: string
        if (!is_null($customsId) && !is_string($customsId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customsId, true), gettype($customsId)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($customsId) && mb_strlen($customsId) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($customsId)), __LINE__);
        }
        $this->customsId = $customsId;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \DBSchenker\StructType\AddressType
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        // validation for constraint: maxLength(250)
        if (!is_null($email) && mb_strlen($email) > 250) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 250', mb_strlen($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->fax;
    }
    /**
     * Set fax value
     * @param string $fax
     * @return \DBSchenker\StructType\AddressType
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        // validation for constraint: maxLength(250)
        if (!is_null($fax) && mb_strlen($fax) > 250) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 250', mb_strlen($fax)), __LINE__);
        }
        $this->fax = $fax;
        return $this;
    }
    /**
     * Get industry value
     * @return string|null
     */
    public function getIndustry()
    {
        return $this->industry;
    }
    /**
     * Set industry value
     * @uses \DBSchenker\EnumType\IndustryType::valueIsValid()
     * @uses \DBSchenker\EnumType\IndustryType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $industry
     * @return \DBSchenker\StructType\AddressType
     */
    public function setIndustry($industry = null)
    {
        // validation for constraint: enumeration
        if (!\DBSchenker\EnumType\IndustryType::valueIsValid($industry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DBSchenker\EnumType\IndustryType', is_array($industry) ? implode(', ', $industry) : var_export($industry, true), implode(', ', \DBSchenker\EnumType\IndustryType::getValidValues())), __LINE__);
        }
        $this->industry = $industry;
        return $this;
    }
    /**
     * Get locationType value
     * @return string|null
     */
    public function getLocationType()
    {
        return $this->locationType;
    }
    /**
     * Set locationType value
     * @uses \DBSchenker\EnumType\LocationType::valueIsValid()
     * @uses \DBSchenker\EnumType\LocationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $locationType
     * @return \DBSchenker\StructType\AddressType
     */
    public function setLocationType($locationType = null)
    {
        // validation for constraint: enumeration
        if (!\DBSchenker\EnumType\LocationType::valueIsValid($locationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DBSchenker\EnumType\LocationType', is_array($locationType) ? implode(', ', $locationType) : var_export($locationType, true), implode(', ', \DBSchenker\EnumType\LocationType::getValidValues())), __LINE__);
        }
        $this->locationType = $locationType;
        return $this;
    }
    /**
     * Get mobilePhone value
     * @return string|null
     */
    public function getMobilePhone()
    {
        return $this->mobilePhone;
    }
    /**
     * Set mobilePhone value
     * @param string $mobilePhone
     * @return \DBSchenker\StructType\AddressType
     */
    public function setMobilePhone($mobilePhone = null)
    {
        // validation for constraint: string
        if (!is_null($mobilePhone) && !is_string($mobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobilePhone, true), gettype($mobilePhone)), __LINE__);
        }
        // validation for constraint: maxLength(250)
        if (!is_null($mobilePhone) && mb_strlen($mobilePhone) > 250) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 250', mb_strlen($mobilePhone)), __LINE__);
        }
        $this->mobilePhone = $mobilePhone;
        return $this;
    }
    /**
     * Get personType value
     * @return string|null
     */
    public function getPersonType()
    {
        return $this->personType;
    }
    /**
     * Set personType value
     * @uses \DBSchenker\EnumType\PersonType::valueIsValid()
     * @uses \DBSchenker\EnumType\PersonType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $personType
     * @return \DBSchenker\StructType\AddressType
     */
    public function setPersonType($personType = null)
    {
        // validation for constraint: enumeration
        if (!\DBSchenker\EnumType\PersonType::valueIsValid($personType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DBSchenker\EnumType\PersonType', is_array($personType) ? implode(', ', $personType) : var_export($personType, true), implode(', ', \DBSchenker\EnumType\PersonType::getValidValues())), __LINE__);
        }
        $this->personType = $personType;
        return $this;
    }
    /**
     * Get phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \DBSchenker\StructType\AddressType
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        // validation for constraint: maxLength(250)
        if (!is_null($phone) && mb_strlen($phone) > 250) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 250', mb_strlen($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get poBox value
     * @return string|null
     */
    public function getPoBox()
    {
        return $this->poBox;
    }
    /**
     * Set poBox value
     * @param string $poBox
     * @return \DBSchenker\StructType\AddressType
     */
    public function setPoBox($poBox = null)
    {
        // validation for constraint: string
        if (!is_null($poBox) && !is_string($poBox)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($poBox, true), gettype($poBox)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($poBox) && mb_strlen($poBox) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($poBox)), __LINE__);
        }
        $this->poBox = $poBox;
        return $this;
    }
    /**
     * Get postalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->postalCode;
    }
    /**
     * Set postalCode value
     * @param string $postalCode
     * @return \DBSchenker\StructType\AddressType
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($postalCode) && mb_strlen($postalCode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($postalCode)), __LINE__);
        }
        $this->postalCode = $postalCode;
        return $this;
    }
    /**
     * Get stateCode value
     * @return string|null
     */
    public function getStateCode()
    {
        return $this->stateCode;
    }
    /**
     * Set stateCode value
     * @param string $stateCode
     * @return \DBSchenker\StructType\AddressType
     */
    public function setStateCode($stateCode = null)
    {
        // validation for constraint: string
        if (!is_null($stateCode) && !is_string($stateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateCode, true), gettype($stateCode)), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($stateCode) && mb_strlen($stateCode) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen($stateCode)), __LINE__);
        }
        $this->stateCode = $stateCode;
        return $this;
    }
    /**
     * Get stateName value
     * @return string|null
     */
    public function getStateName()
    {
        return $this->stateName;
    }
    /**
     * Set stateName value
     * @param string $stateName
     * @return \DBSchenker\StructType\AddressType
     */
    public function setStateName($stateName = null)
    {
        // validation for constraint: string
        if (!is_null($stateName) && !is_string($stateName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateName, true), gettype($stateName)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($stateName) && mb_strlen($stateName) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($stateName)), __LINE__);
        }
        $this->stateName = $stateName;
        return $this;
    }
    /**
     * Get preferredLanguage value
     * @return string|null
     */
    public function getPreferredLanguage()
    {
        return $this->preferredLanguage;
    }
    /**
     * Set preferredLanguage value
     * @param string $preferredLanguage
     * @return \DBSchenker\StructType\AddressType
     */
    public function setPreferredLanguage($preferredLanguage = null)
    {
        // validation for constraint: string
        if (!is_null($preferredLanguage) && !is_string($preferredLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preferredLanguage, true), gettype($preferredLanguage)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($preferredLanguage) && mb_strlen($preferredLanguage) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($preferredLanguage)), __LINE__);
        }
        $this->preferredLanguage = $preferredLanguage;
        return $this;
    }
    /**
     * Get schenkerAddressId value
     * @return string|null
     */
    public function getSchenkerAddressId()
    {
        return $this->schenkerAddressId;
    }
    /**
     * Set schenkerAddressId value
     * @param string $schenkerAddressId
     * @return \DBSchenker\StructType\AddressType
     */
    public function setSchenkerAddressId($schenkerAddressId = null)
    {
        // validation for constraint: string
        if (!is_null($schenkerAddressId) && !is_string($schenkerAddressId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schenkerAddressId, true), gettype($schenkerAddressId)), __LINE__);
        }
        // validation for constraint: maxLength(36)
        if (!is_null($schenkerAddressId) && mb_strlen($schenkerAddressId) > 36) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 36', mb_strlen($schenkerAddressId)), __LINE__);
        }
        $this->schenkerAddressId = $schenkerAddressId;
        return $this;
    }
    /**
     * Get street2 value
     * @return string|null
     */
    public function getStreet2()
    {
        return $this->street2;
    }
    /**
     * Set street2 value
     * @param string $street2
     * @return \DBSchenker\StructType\AddressType
     */
    public function setStreet2($street2 = null)
    {
        // validation for constraint: string
        if (!is_null($street2) && !is_string($street2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street2, true), gettype($street2)), __LINE__);
        }
        // validation for constraint: maxLength(1000)
        if (!is_null($street2) && mb_strlen($street2) > 1000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1000', mb_strlen($street2)), __LINE__);
        }
        $this->street2 = $street2;
        return $this;
    }
}
