<?php

namespace DBSchenker\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for vehicleType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Defines vehicle type
 * @subpackage Enumerations
 */
class VehicleType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'TRAILER'
     * @return string 'TRAILER'
     */
    const VALUE_TRAILER = 'TRAILER';
    /**
     * Constant for value 'ROAD_TRAIN'
     * @return string 'ROAD_TRAIN'
     */
    const VALUE_ROAD_TRAIN = 'ROAD_TRAIN';
    /**
     * Constant for value 'RIGID_TRUCK'
     * @return string 'RIGID_TRUCK'
     */
    const VALUE_RIGID_TRUCK = 'RIGID_TRUCK';
    /**
     * Constant for value 'VAN'
     * @return string 'VAN'
     */
    const VALUE_VAN = 'VAN';
    /**
     * Return allowed values
     * @uses self::VALUE_TRAILER
     * @uses self::VALUE_ROAD_TRAIN
     * @uses self::VALUE_RIGID_TRUCK
     * @uses self::VALUE_VAN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TRAILER,
            self::VALUE_ROAD_TRAIN,
            self::VALUE_RIGID_TRUCK,
            self::VALUE_VAN,
        );
    }
}
