<?php

namespace DBSchenker\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for timeWindowOptionType EnumType
 * Meta information extracted from the WSDL
 * - documentation: MORNING: 09:00 - 12:00 / AFTERNOON: 13:00 - 16:00
 * @subpackage Enumerations
 */
class TimeWindowOptionType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'MORNING'
     * @return string 'MORNING'
     */
    const VALUE_MORNING = 'MORNING';
    /**
     * Constant for value 'AFTERNOON'
     * @return string 'AFTERNOON'
     */
    const VALUE_AFTERNOON = 'AFTERNOON';
    /**
     * Return allowed values
     * @uses self::VALUE_MORNING
     * @uses self::VALUE_AFTERNOON
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MORNING,
            self::VALUE_AFTERNOON,
        );
    }
}
