<?php

namespace DBSchenker\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for personType EnumType
 * Meta information extracted from the WSDL
 * - documentation: valid values : PERSON, COMPANY
 * @subpackage Enumerations
 */
class PersonType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'PERSON'
     * @return string 'PERSON'
     */
    const VALUE_PERSON = 'PERSON';
    /**
     * Constant for value 'COMPANY'
     * @return string 'COMPANY'
     */
    const VALUE_COMPANY = 'COMPANY';
    /**
     * Return allowed values
     * @uses self::VALUE_PERSON
     * @uses self::VALUE_COMPANY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PERSON,
            self::VALUE_COMPANY,
        );
    }
}
