<?php

namespace DBSchenker\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for shippingInformationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Holds shipping information
 * @subpackage Structs
 */
class ShippingInformationType extends AbstractStructBase
{
    /**
     * The shipmentPosition
     * Meta information extracted from the WSDL
     * - documentation: Holds list of shipment positions
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * - nillable: true
     * @var \DBSchenker\StructType\ShipmentPositionType[]
     */
    public $shipmentPosition;
    /**
     * The grossWeight
     * Meta information extracted from the WSDL
     * - documentation: Defines total gross weight | Holds shipment positions total gross weight | Specifies shipment position gross weight | Specifies gross weight of package line
     * - base: xs:decimal
     * - fractionDigits: 2
     * - minExclusive: 0
     * - pattern: [^\.]*(\.[0-9]{1,2})?
     * - totalDigits: 10
     * @var float
     */
    public $grossWeight;
    /**
     * The volume
     * Meta information extracted from the WSDL
     * - documentation: Holds shipment positions total volume | Specifies shipment position volume | Specifies volume of package line
     * - base: xs:decimal
     * - fractionDigits: 3
     * - minExclusive: 0
     * - pattern: [^\.]*(\.[0-9]{1,3})?
     * - totalDigits: 11
     * @var float
     */
    public $volume;
    /**
     * Constructor method for shippingInformationType
     * @uses ShippingInformationType::setShipmentPosition()
     * @uses ShippingInformationType::setGrossWeight()
     * @uses ShippingInformationType::setVolume()
     * @param \DBSchenker\StructType\ShipmentPositionType[] $shipmentPosition
     * @param float $grossWeight
     * @param float $volume
     */
    public function __construct(array $shipmentPosition = array(), $grossWeight = null, $volume = null)
    {
        $this
            ->setShipmentPosition($shipmentPosition)
            ->setGrossWeight($grossWeight)
            ->setVolume($volume);
    }
    /**
     * Get shipmentPosition value
     * @return \DBSchenker\StructType\ShipmentPositionType[]
     */
    public function getShipmentPosition()
    {
        return $this->shipmentPosition;
    }
    /**
     * This method is responsible for validating the values passed to the setShipmentPosition method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipmentPosition method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentPositionForArrayConstraintsFromSetShipmentPosition(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shippingInformationTypeShipmentPositionItem) {
            // validation for constraint: itemType
            if (!$shippingInformationTypeShipmentPositionItem instanceof \DBSchenker\StructType\ShipmentPositionType) {
                $invalidValues[] = is_object($shippingInformationTypeShipmentPositionItem) ? get_class($shippingInformationTypeShipmentPositionItem) : sprintf('%s(%s)', gettype($shippingInformationTypeShipmentPositionItem), var_export($shippingInformationTypeShipmentPositionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The shipmentPosition property can only contain items of type \DBSchenker\StructType\ShipmentPositionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set shipmentPosition value
     * @throws \InvalidArgumentException
     * @param \DBSchenker\StructType\ShipmentPositionType[] $shipmentPosition
     * @return \DBSchenker\StructType\ShippingInformationType
     */
    public function setShipmentPosition(array $shipmentPosition = array())
    {
        // validation for constraint: array
        if ('' !== ($shipmentPositionArrayErrorMessage = self::validateShipmentPositionForArrayConstraintsFromSetShipmentPosition($shipmentPosition))) {
            throw new \InvalidArgumentException($shipmentPositionArrayErrorMessage, __LINE__);
        }
        $this->shipmentPosition = $shipmentPosition;
        return $this;
    }
    /**
     * Add item to shipmentPosition value
     * @throws \InvalidArgumentException
     * @param \DBSchenker\StructType\ShipmentPositionType $item
     * @return \DBSchenker\StructType\ShippingInformationType
     */
    public function addToShipmentPosition(\DBSchenker\StructType\ShipmentPositionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \DBSchenker\StructType\ShipmentPositionType) {
            throw new \InvalidArgumentException(sprintf('The shipmentPosition property can only contain items of type \DBSchenker\StructType\ShipmentPositionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->shipmentPosition[] = $item;
        return $this;
    }
    /**
     * Get grossWeight value
     * @return float|null
     */
    public function getGrossWeight()
    {
        return $this->grossWeight;
    }
    /**
     * Set grossWeight value
     * @param float $grossWeight
     * @return \DBSchenker\StructType\ShippingInformationType
     */
    public function setGrossWeight($grossWeight = null)
    {
        // validation for constraint: float
        if (!is_null($grossWeight) && !(is_float($grossWeight) || is_numeric($grossWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($grossWeight, true), gettype($grossWeight)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($grossWeight) && mb_strlen(mb_substr($grossWeight, false !== mb_strpos($grossWeight, '.') ? mb_strpos($grossWeight, '.') + 1 : mb_strlen($grossWeight))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($grossWeight, true), mb_strlen(mb_substr($grossWeight, mb_strpos($grossWeight, '.') + 1))), __LINE__);
        }
        // validation for constraint: minExclusive
        if (!is_null($grossWeight) && $grossWeight <= 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than 0', var_export($grossWeight, true)), __LINE__);
        }
        // validation for constraint: pattern([^\.]*(\.[0-9]{1,2})?)
        if (!is_null($grossWeight) && !preg_match('/[^\\.]*(\\.[0-9]{1,2})?/', $grossWeight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [^\.]*(\.[0-9]{1,2})?', var_export($grossWeight, true)), __LINE__);
        }
        // validation for constraint: totalDigits(10)
        if (!is_null($grossWeight) && mb_strlen(preg_replace('/(\D)/', '', $grossWeight)) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 10 digits, "%d" given', var_export($grossWeight, true), mb_strlen(preg_replace('/(\D)/', '', $grossWeight))), __LINE__);
        }
        $this->grossWeight = $grossWeight;
        return $this;
    }
    /**
     * Get volume value
     * @return float|null
     */
    public function getVolume()
    {
        return $this->volume;
    }
    /**
     * Set volume value
     * @param float $volume
     * @return \DBSchenker\StructType\ShippingInformationType
     */
    public function setVolume($volume = null)
    {
        // validation for constraint: float
        if (!is_null($volume) && !(is_float($volume) || is_numeric($volume))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($volume, true), gettype($volume)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($volume) && mb_strlen(mb_substr($volume, false !== mb_strpos($volume, '.') ? mb_strpos($volume, '.') + 1 : mb_strlen($volume))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($volume, true), mb_strlen(mb_substr($volume, mb_strpos($volume, '.') + 1))), __LINE__);
        }
        // validation for constraint: minExclusive
        if (!is_null($volume) && $volume <= 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than 0', var_export($volume, true)), __LINE__);
        }
        // validation for constraint: pattern([^\.]*(\.[0-9]{1,3})?)
        if (!is_null($volume) && !preg_match('/[^\\.]*(\\.[0-9]{1,3})?/', $volume)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [^\.]*(\.[0-9]{1,3})?', var_export($volume, true)), __LINE__);
        }
        // validation for constraint: totalDigits(11)
        if (!is_null($volume) && mb_strlen(preg_replace('/(\D)/', '', $volume)) > 11) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 11 digits, "%d" given', var_export($volume, true), mb_strlen(preg_replace('/(\D)/', '', $volume))), __LINE__);
        }
        $this->volume = $volume;
        return $this;
    }
}
