<?php

namespace DBSchenker\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for shipmentPositionType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines shipment position of shipping information
 * @subpackage Structs
 */
class ShipmentPositionType extends AbstractStructBase
{
    /**
     * The cargoDesc
     * Meta information extracted from the WSDL
     * - documentation: Specifies cargo description | Specifies cargo description of package line
     * - base: xs:string
     * - maxLength: 500
     * - minOccurs: 1
     * @var string
     */
    public $cargoDesc;
    /**
     * The volume
     * Meta information extracted from the WSDL
     * - documentation: Holds shipment positions total volume | Specifies shipment position volume | Specifies volume of package line
     * - base: xs:decimal
     * - fractionDigits: 3
     * - minExclusive: 0
     * - minOccurs: 1
     * - pattern: [^\.]*(\.[0-9]{1,3})?
     * - totalDigits: 11
     * @var float
     */
    public $volume;
    /**
     * The grossWeight
     * Meta information extracted from the WSDL
     * - documentation: Defines total gross weight | Holds shipment positions total gross weight | Specifies shipment position gross weight | Specifies gross weight of package line
     * - base: xs:decimal
     * - fractionDigits: 2
     * - minExclusive: 0
     * - minOccurs: 1
     * - pattern: [^\.]*(\.[0-9]{1,2})?
     * - totalDigits: 10
     * @var float
     */
    public $grossWeight;
    /**
     * The packageType
     * Meta information extracted from the WSDL
     * - documentation: Defines shipment position package type | Specifies dangerous goods package type
     * - base: xs:string
     * - maxLength: 50
     * - minOccurs: 1
     * @var string
     */
    public $packageType;
    /**
     * The dangerousGoods
     * Meta information extracted from the WSDL
     * - documentation: Holds list of dangerous goods
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \DBSchenker\StructType\DangerousGoodsType[]
     */
    public $dangerousGoods;
    /**
     * The dgr
     * Meta information extracted from the WSDL
     * - documentation: Specifies if dangerous goods are required
     * @var bool
     */
    public $dgr;
    /**
     * The length
     * Meta information extracted from the WSDL
     * - documentation: Specifies shipment position length | Specifies length of package line
     * - base: xs:decimal
     * - fractionDigits: 2
     * - minExclusive: 0
     * - minOccurs: 0
     * - pattern: [^\.]*(\.[0-9]{1,2})?
     * - totalDigits: 10
     * @var float
     */
    public $length;
    /**
     * The width
     * Meta information extracted from the WSDL
     * - documentation: Specifies shipment position width | Specifies width of package line
     * - base: xs:decimal
     * - fractionDigits: 2
     * - minExclusive: 0
     * - minOccurs: 0
     * - pattern: [^\.]*(\.[0-9]{1,2})?
     * - totalDigits: 10
     * @var float
     */
    public $width;
    /**
     * The height
     * Meta information extracted from the WSDL
     * - documentation: Specifies shipment position height | Specifies height of package line
     * - base: xs:decimal
     * - fractionDigits: 2
     * - minExclusive: 0
     * - minOccurs: 0
     * - pattern: [^\.]*(\.[0-9]{1,2})?
     * - totalDigits: 10
     * @var float
     */
    public $height;
    /**
     * The marksAndNumbers
     * Meta information extracted from the WSDL
     * - documentation: Specifies shipment position marks and numbers
     * - base: xs:string
     * - maxLength: 500
     * - minOccurs: 0
     * @var string
     */
    public $marksAndNumbers;
    /**
     * The packageLine
     * Meta information extracted from the WSDL
     * - documentation: Holds shipment position package lines
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \DBSchenker\StructType\PackageLineType[]
     */
    public $packageLine;
    /**
     * The pieces
     * Meta information extracted from the WSDL
     * - documentation: Specifies shipment position pieces amount
     * @var int
     */
    public $pieces;
    /**
     * The stackable
     * Meta information extracted from the WSDL
     * - documentation: Defines if shipment position is stackable
     * @var bool
     */
    public $stackable;
    /**
     * Constructor method for shipmentPositionType
     * @uses ShipmentPositionType::setCargoDesc()
     * @uses ShipmentPositionType::setVolume()
     * @uses ShipmentPositionType::setGrossWeight()
     * @uses ShipmentPositionType::setPackageType()
     * @uses ShipmentPositionType::setDangerousGoods()
     * @uses ShipmentPositionType::setDgr()
     * @uses ShipmentPositionType::setLength()
     * @uses ShipmentPositionType::setWidth()
     * @uses ShipmentPositionType::setHeight()
     * @uses ShipmentPositionType::setMarksAndNumbers()
     * @uses ShipmentPositionType::setPackageLine()
     * @uses ShipmentPositionType::setPieces()
     * @uses ShipmentPositionType::setStackable()
     * @param string $cargoDesc
     * @param float $volume
     * @param float $grossWeight
     * @param string $packageType
     * @param \DBSchenker\StructType\DangerousGoodsType[] $dangerousGoods
     * @param bool $dgr
     * @param float $length
     * @param float $width
     * @param float $height
     * @param string $marksAndNumbers
     * @param \DBSchenker\StructType\PackageLineType[] $packageLine
     * @param int $pieces
     * @param bool $stackable
     */
    public function __construct($cargoDesc = null, $volume = null, $grossWeight = null, $packageType = null, array $dangerousGoods = array(), $dgr = null, $length = null, $width = null, $height = null, $marksAndNumbers = null, array $packageLine = array(), $pieces = null, $stackable = null)
    {
        $this
            ->setCargoDesc($cargoDesc)
            ->setVolume($volume)
            ->setGrossWeight($grossWeight)
            ->setPackageType($packageType)
            ->setDangerousGoods($dangerousGoods)
            ->setDgr($dgr)
            ->setLength($length)
            ->setWidth($width)
            ->setHeight($height)
            ->setMarksAndNumbers($marksAndNumbers)
            ->setPackageLine($packageLine)
            ->setPieces($pieces)
            ->setStackable($stackable);
    }
    /**
     * Get cargoDesc value
     * @return string
     */
    public function getCargoDesc()
    {
        return $this->cargoDesc;
    }
    /**
     * Set cargoDesc value
     * @param string $cargoDesc
     * @return \DBSchenker\StructType\ShipmentPositionType
     */
    public function setCargoDesc($cargoDesc = null)
    {
        // validation for constraint: string
        if (!is_null($cargoDesc) && !is_string($cargoDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cargoDesc, true), gettype($cargoDesc)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($cargoDesc) && mb_strlen($cargoDesc) > 500) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen($cargoDesc)), __LINE__);
        }
        $this->cargoDesc = $cargoDesc;
        return $this;
    }
    /**
     * Get volume value
     * @return float
     */
    public function getVolume()
    {
        return $this->volume;
    }
    /**
     * Set volume value
     * @param float $volume
     * @return \DBSchenker\StructType\ShipmentPositionType
     */
    public function setVolume($volume = null)
    {
        // validation for constraint: float
        if (!is_null($volume) && !(is_float($volume) || is_numeric($volume))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($volume, true), gettype($volume)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($volume) && mb_strlen(mb_substr($volume, false !== mb_strpos($volume, '.') ? mb_strpos($volume, '.') + 1 : mb_strlen($volume))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($volume, true), mb_strlen(mb_substr($volume, mb_strpos($volume, '.') + 1))), __LINE__);
        }
        // validation for constraint: minExclusive
        if (!is_null($volume) && $volume <= 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than 0', var_export($volume, true)), __LINE__);
        }
        // validation for constraint: pattern([^\.]*(\.[0-9]{1,3})?)
        if (!is_null($volume) && !preg_match('/[^\\.]*(\\.[0-9]{1,3})?/', $volume)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [^\.]*(\.[0-9]{1,3})?', var_export($volume, true)), __LINE__);
        }
        // validation for constraint: totalDigits(11)
        if (!is_null($volume) && mb_strlen(preg_replace('/(\D)/', '', $volume)) > 11) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 11 digits, "%d" given', var_export($volume, true), mb_strlen(preg_replace('/(\D)/', '', $volume))), __LINE__);
        }
        $this->volume = $volume;
        return $this;
    }
    /**
     * Get grossWeight value
     * @return float
     */
    public function getGrossWeight()
    {
        return $this->grossWeight;
    }
    /**
     * Set grossWeight value
     * @param float $grossWeight
     * @return \DBSchenker\StructType\ShipmentPositionType
     */
    public function setGrossWeight($grossWeight = null)
    {
        // validation for constraint: float
        if (!is_null($grossWeight) && !(is_float($grossWeight) || is_numeric($grossWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($grossWeight, true), gettype($grossWeight)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($grossWeight) && mb_strlen(mb_substr($grossWeight, false !== mb_strpos($grossWeight, '.') ? mb_strpos($grossWeight, '.') + 1 : mb_strlen($grossWeight))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($grossWeight, true), mb_strlen(mb_substr($grossWeight, mb_strpos($grossWeight, '.') + 1))), __LINE__);
        }
        // validation for constraint: minExclusive
        if (!is_null($grossWeight) && $grossWeight <= 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than 0', var_export($grossWeight, true)), __LINE__);
        }
        // validation for constraint: pattern([^\.]*(\.[0-9]{1,2})?)
        if (!is_null($grossWeight) && !preg_match('/[^\\.]*(\\.[0-9]{1,2})?/', $grossWeight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [^\.]*(\.[0-9]{1,2})?', var_export($grossWeight, true)), __LINE__);
        }
        // validation for constraint: totalDigits(10)
        if (!is_null($grossWeight) && mb_strlen(preg_replace('/(\D)/', '', $grossWeight)) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 10 digits, "%d" given', var_export($grossWeight, true), mb_strlen(preg_replace('/(\D)/', '', $grossWeight))), __LINE__);
        }
        $this->grossWeight = $grossWeight;
        return $this;
    }
    /**
     * Get packageType value
     * @return string
     */
    public function getPackageType()
    {
        return $this->packageType;
    }
    /**
     * Set packageType value
     * @param string $packageType
     * @return \DBSchenker\StructType\ShipmentPositionType
     */
    public function setPackageType($packageType = null)
    {
        // validation for constraint: string
        if (!is_null($packageType) && !is_string($packageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageType, true), gettype($packageType)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($packageType) && mb_strlen($packageType) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($packageType)), __LINE__);
        }
        $this->packageType = $packageType;
        return $this;
    }
    /**
     * Get dangerousGoods value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \DBSchenker\StructType\DangerousGoodsType[]|null
     */
    public function getDangerousGoods()
    {
        return isset($this->dangerousGoods) ? $this->dangerousGoods : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDangerousGoods method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDangerousGoods method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDangerousGoodsForArrayConstraintsFromSetDangerousGoods(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentPositionTypeDangerousGoodsItem) {
            // validation for constraint: itemType
            if (!$shipmentPositionTypeDangerousGoodsItem instanceof \DBSchenker\StructType\DangerousGoodsType) {
                $invalidValues[] = is_object($shipmentPositionTypeDangerousGoodsItem) ? get_class($shipmentPositionTypeDangerousGoodsItem) : sprintf('%s(%s)', gettype($shipmentPositionTypeDangerousGoodsItem), var_export($shipmentPositionTypeDangerousGoodsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The dangerousGoods property can only contain items of type \DBSchenker\StructType\DangerousGoodsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set dangerousGoods value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \DBSchenker\StructType\DangerousGoodsType[] $dangerousGoods
     * @return \DBSchenker\StructType\ShipmentPositionType
     */
    public function setDangerousGoods(array $dangerousGoods = array())
    {
        // validation for constraint: array
        if ('' !== ($dangerousGoodsArrayErrorMessage = self::validateDangerousGoodsForArrayConstraintsFromSetDangerousGoods($dangerousGoods))) {
            throw new \InvalidArgumentException($dangerousGoodsArrayErrorMessage, __LINE__);
        }
        if (is_null($dangerousGoods) || (is_array($dangerousGoods) && empty($dangerousGoods))) {
            unset($this->dangerousGoods);
        } else {
            $this->dangerousGoods = $dangerousGoods;
        }
        return $this;
    }
    /**
     * Add item to dangerousGoods value
     * @throws \InvalidArgumentException
     * @param \DBSchenker\StructType\DangerousGoodsType $item
     * @return \DBSchenker\StructType\ShipmentPositionType
     */
    public function addToDangerousGoods(\DBSchenker\StructType\DangerousGoodsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \DBSchenker\StructType\DangerousGoodsType) {
            throw new \InvalidArgumentException(sprintf('The dangerousGoods property can only contain items of type \DBSchenker\StructType\DangerousGoodsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->dangerousGoods[] = $item;
        return $this;
    }
    /**
     * Get dgr value
     * @return bool|null
     */
    public function getDgr()
    {
        return $this->dgr;
    }
    /**
     * Set dgr value
     * @param bool $dgr
     * @return \DBSchenker\StructType\ShipmentPositionType
     */
    public function setDgr($dgr = null)
    {
        // validation for constraint: boolean
        if (!is_null($dgr) && !is_bool($dgr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($dgr, true), gettype($dgr)), __LINE__);
        }
        $this->dgr = $dgr;
        return $this;
    }
    /**
     * Get length value
     * @return float|null
     */
    public function getLength()
    {
        return $this->length;
    }
    /**
     * Set length value
     * @param float $length
     * @return \DBSchenker\StructType\ShipmentPositionType
     */
    public function setLength($length = null)
    {
        // validation for constraint: float
        if (!is_null($length) && !(is_float($length) || is_numeric($length))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($length, true), gettype($length)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($length) && mb_strlen(mb_substr($length, false !== mb_strpos($length, '.') ? mb_strpos($length, '.') + 1 : mb_strlen($length))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($length, true), mb_strlen(mb_substr($length, mb_strpos($length, '.') + 1))), __LINE__);
        }
        // validation for constraint: minExclusive
        if (!is_null($length) && $length <= 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than 0', var_export($length, true)), __LINE__);
        }
        // validation for constraint: pattern([^\.]*(\.[0-9]{1,2})?)
        if (!is_null($length) && !preg_match('/[^\\.]*(\\.[0-9]{1,2})?/', $length)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [^\.]*(\.[0-9]{1,2})?', var_export($length, true)), __LINE__);
        }
        // validation for constraint: totalDigits(10)
        if (!is_null($length) && mb_strlen(preg_replace('/(\D)/', '', $length)) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 10 digits, "%d" given', var_export($length, true), mb_strlen(preg_replace('/(\D)/', '', $length))), __LINE__);
        }
        $this->length = $length;
        return $this;
    }
    /**
     * Get width value
     * @return float|null
     */
    public function getWidth()
    {
        return $this->width;
    }
    /**
     * Set width value
     * @param float $width
     * @return \DBSchenker\StructType\ShipmentPositionType
     */
    public function setWidth($width = null)
    {
        // validation for constraint: float
        if (!is_null($width) && !(is_float($width) || is_numeric($width))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($width, true), gettype($width)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($width) && mb_strlen(mb_substr($width, false !== mb_strpos($width, '.') ? mb_strpos($width, '.') + 1 : mb_strlen($width))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($width, true), mb_strlen(mb_substr($width, mb_strpos($width, '.') + 1))), __LINE__);
        }
        // validation for constraint: minExclusive
        if (!is_null($width) && $width <= 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than 0', var_export($width, true)), __LINE__);
        }
        // validation for constraint: pattern([^\.]*(\.[0-9]{1,2})?)
        if (!is_null($width) && !preg_match('/[^\\.]*(\\.[0-9]{1,2})?/', $width)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [^\.]*(\.[0-9]{1,2})?', var_export($width, true)), __LINE__);
        }
        // validation for constraint: totalDigits(10)
        if (!is_null($width) && mb_strlen(preg_replace('/(\D)/', '', $width)) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 10 digits, "%d" given', var_export($width, true), mb_strlen(preg_replace('/(\D)/', '', $width))), __LINE__);
        }
        $this->width = $width;
        return $this;
    }
    /**
     * Get height value
     * @return float|null
     */
    public function getHeight()
    {
        return $this->height;
    }
    /**
     * Set height value
     * @param float $height
     * @return \DBSchenker\StructType\ShipmentPositionType
     */
    public function setHeight($height = null)
    {
        // validation for constraint: float
        if (!is_null($height) && !(is_float($height) || is_numeric($height))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($height, true), gettype($height)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($height) && mb_strlen(mb_substr($height, false !== mb_strpos($height, '.') ? mb_strpos($height, '.') + 1 : mb_strlen($height))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($height, true), mb_strlen(mb_substr($height, mb_strpos($height, '.') + 1))), __LINE__);
        }
        // validation for constraint: minExclusive
        if (!is_null($height) && $height <= 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than 0', var_export($height, true)), __LINE__);
        }
        // validation for constraint: pattern([^\.]*(\.[0-9]{1,2})?)
        if (!is_null($height) && !preg_match('/[^\\.]*(\\.[0-9]{1,2})?/', $height)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [^\.]*(\.[0-9]{1,2})?', var_export($height, true)), __LINE__);
        }
        // validation for constraint: totalDigits(10)
        if (!is_null($height) && mb_strlen(preg_replace('/(\D)/', '', $height)) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 10 digits, "%d" given', var_export($height, true), mb_strlen(preg_replace('/(\D)/', '', $height))), __LINE__);
        }
        $this->height = $height;
        return $this;
    }
    /**
     * Get marksAndNumbers value
     * @return string|null
     */
    public function getMarksAndNumbers()
    {
        return $this->marksAndNumbers;
    }
    /**
     * Set marksAndNumbers value
     * @param string $marksAndNumbers
     * @return \DBSchenker\StructType\ShipmentPositionType
     */
    public function setMarksAndNumbers($marksAndNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($marksAndNumbers) && !is_string($marksAndNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marksAndNumbers, true), gettype($marksAndNumbers)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($marksAndNumbers) && mb_strlen($marksAndNumbers) > 500) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen($marksAndNumbers)), __LINE__);
        }
        $this->marksAndNumbers = $marksAndNumbers;
        return $this;
    }
    /**
     * Get packageLine value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \DBSchenker\StructType\PackageLineType[]|null
     */
    public function getPackageLine()
    {
        return isset($this->packageLine) ? $this->packageLine : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPackageLine method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackageLine method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackageLineForArrayConstraintsFromSetPackageLine(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentPositionTypePackageLineItem) {
            // validation for constraint: itemType
            if (!$shipmentPositionTypePackageLineItem instanceof \DBSchenker\StructType\PackageLineType) {
                $invalidValues[] = is_object($shipmentPositionTypePackageLineItem) ? get_class($shipmentPositionTypePackageLineItem) : sprintf('%s(%s)', gettype($shipmentPositionTypePackageLineItem), var_export($shipmentPositionTypePackageLineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The packageLine property can only contain items of type \DBSchenker\StructType\PackageLineType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set packageLine value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \DBSchenker\StructType\PackageLineType[] $packageLine
     * @return \DBSchenker\StructType\ShipmentPositionType
     */
    public function setPackageLine(array $packageLine = array())
    {
        // validation for constraint: array
        if ('' !== ($packageLineArrayErrorMessage = self::validatePackageLineForArrayConstraintsFromSetPackageLine($packageLine))) {
            throw new \InvalidArgumentException($packageLineArrayErrorMessage, __LINE__);
        }
        if (is_null($packageLine) || (is_array($packageLine) && empty($packageLine))) {
            unset($this->packageLine);
        } else {
            $this->packageLine = $packageLine;
        }
        return $this;
    }
    /**
     * Add item to packageLine value
     * @throws \InvalidArgumentException
     * @param \DBSchenker\StructType\PackageLineType $item
     * @return \DBSchenker\StructType\ShipmentPositionType
     */
    public function addToPackageLine(\DBSchenker\StructType\PackageLineType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \DBSchenker\StructType\PackageLineType) {
            throw new \InvalidArgumentException(sprintf('The packageLine property can only contain items of type \DBSchenker\StructType\PackageLineType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->packageLine[] = $item;
        return $this;
    }
    /**
     * Get pieces value
     * @return int|null
     */
    public function getPieces()
    {
        return $this->pieces;
    }
    /**
     * Set pieces value
     * @param int $pieces
     * @return \DBSchenker\StructType\ShipmentPositionType
     */
    public function setPieces($pieces = null)
    {
        // validation for constraint: int
        if (!is_null($pieces) && !(is_int($pieces) || ctype_digit($pieces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pieces, true), gettype($pieces)), __LINE__);
        }
        $this->pieces = $pieces;
        return $this;
    }
    /**
     * Get stackable value
     * @return bool|null
     */
    public function getStackable()
    {
        return $this->stackable;
    }
    /**
     * Set stackable value
     * @param bool $stackable
     * @return \DBSchenker\StructType\ShipmentPositionType
     */
    public function setStackable($stackable = null)
    {
        // validation for constraint: boolean
        if (!is_null($stackable) && !is_bool($stackable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($stackable, true), gettype($stackable)), __LINE__);
        }
        $this->stackable = $stackable;
        return $this;
    }
}
