<?php

namespace DBSchenker\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for returnPallet StructType
 * Meta information extracted from the WSDL
 * - documentation: Holds return pallet pieces information
 * @subpackage Structs
 */
class ReturnPallet extends AbstractStructBase
{
    /**
     * The pieces
     * Meta information extracted from the WSDL
     * - documentation: Number of pieces (1-999)
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $pieces;
    /**
     * Constructor method for returnPallet
     * @uses ReturnPallet::setPieces()
     * @param int $pieces
     */
    public function __construct($pieces = null)
    {
        $this
            ->setPieces($pieces);
    }
    /**
     * Get pieces value
     * @return int|null
     */
    public function getPieces()
    {
        return $this->pieces;
    }
    /**
     * Set pieces value
     * @param int $pieces
     * @return \DBSchenker\StructType\ReturnPallet
     */
    public function setPieces($pieces = null)
    {
        // validation for constraint: int
        if (!is_null($pieces) && !(is_int($pieces) || ctype_digit($pieces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pieces, true), gettype($pieces)), __LINE__);
        }
        $this->pieces = $pieces;
        return $this;
    }
}
