<?php

namespace DBSchenker\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for preNoticeContactType StructType
 * Meta information extracted from the WSDL
 * - documentation: Holds contact information.
 * @subpackage Structs
 */
class PreNoticeContactType extends AbstractStructBase
{
    /**
     * The contactPerson
     * Meta information extracted from the WSDL
     * - documentation: The contact person's name.
     * - base: xs:string
     * - maxLength: 500
     * @var string
     */
    public $contactPerson;
    /**
     * The phone
     * Meta information extracted from the WSDL
     * - documentation: Defines phone | Defines contact phone | The contact person's phone number.
     * - base: xs:string
     * - maxLength: 250
     * @var string
     */
    public $phone;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - documentation: Defines email address | Defines email of contact person | Defines email | The contact person's email address.
     * - base: xs:string
     * - maxLength: 250
     * - pattern: [^@]+@[^\.]+\..+
     * @var string
     */
    public $email;
    /**
     * Constructor method for preNoticeContactType
     * @uses PreNoticeContactType::setContactPerson()
     * @uses PreNoticeContactType::setPhone()
     * @uses PreNoticeContactType::setEmail()
     * @param string $contactPerson
     * @param string $phone
     * @param string $email
     */
    public function __construct($contactPerson = null, $phone = null, $email = null)
    {
        $this
            ->setContactPerson($contactPerson)
            ->setPhone($phone)
            ->setEmail($email);
    }
    /**
     * Get contactPerson value
     * @return string|null
     */
    public function getContactPerson()
    {
        return $this->contactPerson;
    }
    /**
     * Set contactPerson value
     * @param string $contactPerson
     * @return \DBSchenker\StructType\PreNoticeContactType
     */
    public function setContactPerson($contactPerson = null)
    {
        // validation for constraint: string
        if (!is_null($contactPerson) && !is_string($contactPerson)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactPerson, true), gettype($contactPerson)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($contactPerson) && mb_strlen($contactPerson) > 500) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen($contactPerson)), __LINE__);
        }
        $this->contactPerson = $contactPerson;
        return $this;
    }
    /**
     * Get phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \DBSchenker\StructType\PreNoticeContactType
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        // validation for constraint: maxLength(250)
        if (!is_null($phone) && mb_strlen($phone) > 250) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 250', mb_strlen($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \DBSchenker\StructType\PreNoticeContactType
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        // validation for constraint: maxLength(250)
        if (!is_null($email) && mb_strlen($email) > 250) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 250', mb_strlen($email)), __LINE__);
        }
        // validation for constraint: pattern([^@]+@[^\.]+\..+)
        if (!is_null($email) && !preg_match('/[^@]+@[^\\.]+\\..+/', $email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [^@]+@[^\.]+\..+', var_export($email, true)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
}
