<?php

namespace DBSchenker\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for packageLineType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines package line of shipment position
 * @subpackage Structs
 */
class PackageLineType extends AbstractStructBase
{
    /**
     * The cargoDesc
     * Meta information extracted from the WSDL
     * - documentation: Specifies cargo description | Specifies cargo description of package line
     * - base: xs:string
     * - maxLength: 500
     * - minOccurs: 0
     * @var string
     */
    public $cargoDesc;
    /**
     * The length
     * Meta information extracted from the WSDL
     * - documentation: Specifies shipment position length | Specifies length of package line
     * - base: xs:decimal
     * - fractionDigits: 2
     * - minExclusive: 0
     * - minOccurs: 0
     * - pattern: [^\.]*(\.[0-9]{1,2})?
     * - totalDigits: 10
     * @var float
     */
    public $length;
    /**
     * The width
     * Meta information extracted from the WSDL
     * - documentation: Specifies shipment position width | Specifies width of package line
     * - base: xs:decimal
     * - fractionDigits: 2
     * - minExclusive: 0
     * - minOccurs: 0
     * - pattern: [^\.]*(\.[0-9]{1,2})?
     * - totalDigits: 10
     * @var float
     */
    public $width;
    /**
     * The height
     * Meta information extracted from the WSDL
     * - documentation: Specifies shipment position height | Specifies height of package line
     * - base: xs:decimal
     * - fractionDigits: 2
     * - minExclusive: 0
     * - minOccurs: 0
     * - pattern: [^\.]*(\.[0-9]{1,2})?
     * - totalDigits: 10
     * @var float
     */
    public $height;
    /**
     * The volume
     * Meta information extracted from the WSDL
     * - documentation: Holds shipment positions total volume | Specifies shipment position volume | Specifies volume of package line
     * - base: xs:decimal
     * - fractionDigits: 3
     * - minExclusive: 0
     * - minOccurs: 0
     * - pattern: [^\.]*(\.[0-9]{1,3})?
     * - totalDigits: 11
     * @var float
     */
    public $volume;
    /**
     * The grossWeight
     * Meta information extracted from the WSDL
     * - documentation: Defines total gross weight | Holds shipment positions total gross weight | Specifies shipment position gross weight | Specifies gross weight of package line
     * - base: xs:decimal
     * - fractionDigits: 2
     * - minExclusive: 0
     * - minOccurs: 0
     * - pattern: [^\.]*(\.[0-9]{1,2})?
     * - totalDigits: 10
     * @var float
     */
    public $grossWeight;
    /**
     * Constructor method for packageLineType
     * @uses PackageLineType::setCargoDesc()
     * @uses PackageLineType::setLength()
     * @uses PackageLineType::setWidth()
     * @uses PackageLineType::setHeight()
     * @uses PackageLineType::setVolume()
     * @uses PackageLineType::setGrossWeight()
     * @param string $cargoDesc
     * @param float $length
     * @param float $width
     * @param float $height
     * @param float $volume
     * @param float $grossWeight
     */
    public function __construct($cargoDesc = null, $length = null, $width = null, $height = null, $volume = null, $grossWeight = null)
    {
        $this
            ->setCargoDesc($cargoDesc)
            ->setLength($length)
            ->setWidth($width)
            ->setHeight($height)
            ->setVolume($volume)
            ->setGrossWeight($grossWeight);
    }
    /**
     * Get cargoDesc value
     * @return string|null
     */
    public function getCargoDesc()
    {
        return $this->cargoDesc;
    }
    /**
     * Set cargoDesc value
     * @param string $cargoDesc
     * @return \DBSchenker\StructType\PackageLineType
     */
    public function setCargoDesc($cargoDesc = null)
    {
        // validation for constraint: string
        if (!is_null($cargoDesc) && !is_string($cargoDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cargoDesc, true), gettype($cargoDesc)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($cargoDesc) && mb_strlen($cargoDesc) > 500) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen($cargoDesc)), __LINE__);
        }
        $this->cargoDesc = $cargoDesc;
        return $this;
    }
    /**
     * Get length value
     * @return float|null
     */
    public function getLength()
    {
        return $this->length;
    }
    /**
     * Set length value
     * @param float $length
     * @return \DBSchenker\StructType\PackageLineType
     */
    public function setLength($length = null)
    {
        // validation for constraint: float
        if (!is_null($length) && !(is_float($length) || is_numeric($length))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($length, true), gettype($length)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($length) && mb_strlen(mb_substr($length, false !== mb_strpos($length, '.') ? mb_strpos($length, '.') + 1 : mb_strlen($length))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($length, true), mb_strlen(mb_substr($length, mb_strpos($length, '.') + 1))), __LINE__);
        }
        // validation for constraint: minExclusive
        if (!is_null($length) && $length <= 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than 0', var_export($length, true)), __LINE__);
        }
        // validation for constraint: pattern([^\.]*(\.[0-9]{1,2})?)
        if (!is_null($length) && !preg_match('/[^\\.]*(\\.[0-9]{1,2})?/', $length)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [^\.]*(\.[0-9]{1,2})?', var_export($length, true)), __LINE__);
        }
        // validation for constraint: totalDigits(10)
        if (!is_null($length) && mb_strlen(preg_replace('/(\D)/', '', $length)) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 10 digits, "%d" given', var_export($length, true), mb_strlen(preg_replace('/(\D)/', '', $length))), __LINE__);
        }
        $this->length = $length;
        return $this;
    }
    /**
     * Get width value
     * @return float|null
     */
    public function getWidth()
    {
        return $this->width;
    }
    /**
     * Set width value
     * @param float $width
     * @return \DBSchenker\StructType\PackageLineType
     */
    public function setWidth($width = null)
    {
        // validation for constraint: float
        if (!is_null($width) && !(is_float($width) || is_numeric($width))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($width, true), gettype($width)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($width) && mb_strlen(mb_substr($width, false !== mb_strpos($width, '.') ? mb_strpos($width, '.') + 1 : mb_strlen($width))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($width, true), mb_strlen(mb_substr($width, mb_strpos($width, '.') + 1))), __LINE__);
        }
        // validation for constraint: minExclusive
        if (!is_null($width) && $width <= 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than 0', var_export($width, true)), __LINE__);
        }
        // validation for constraint: pattern([^\.]*(\.[0-9]{1,2})?)
        if (!is_null($width) && !preg_match('/[^\\.]*(\\.[0-9]{1,2})?/', $width)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [^\.]*(\.[0-9]{1,2})?', var_export($width, true)), __LINE__);
        }
        // validation for constraint: totalDigits(10)
        if (!is_null($width) && mb_strlen(preg_replace('/(\D)/', '', $width)) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 10 digits, "%d" given', var_export($width, true), mb_strlen(preg_replace('/(\D)/', '', $width))), __LINE__);
        }
        $this->width = $width;
        return $this;
    }
    /**
     * Get height value
     * @return float|null
     */
    public function getHeight()
    {
        return $this->height;
    }
    /**
     * Set height value
     * @param float $height
     * @return \DBSchenker\StructType\PackageLineType
     */
    public function setHeight($height = null)
    {
        // validation for constraint: float
        if (!is_null($height) && !(is_float($height) || is_numeric($height))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($height, true), gettype($height)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($height) && mb_strlen(mb_substr($height, false !== mb_strpos($height, '.') ? mb_strpos($height, '.') + 1 : mb_strlen($height))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($height, true), mb_strlen(mb_substr($height, mb_strpos($height, '.') + 1))), __LINE__);
        }
        // validation for constraint: minExclusive
        if (!is_null($height) && $height <= 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than 0', var_export($height, true)), __LINE__);
        }
        // validation for constraint: pattern([^\.]*(\.[0-9]{1,2})?)
        if (!is_null($height) && !preg_match('/[^\\.]*(\\.[0-9]{1,2})?/', $height)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [^\.]*(\.[0-9]{1,2})?', var_export($height, true)), __LINE__);
        }
        // validation for constraint: totalDigits(10)
        if (!is_null($height) && mb_strlen(preg_replace('/(\D)/', '', $height)) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 10 digits, "%d" given', var_export($height, true), mb_strlen(preg_replace('/(\D)/', '', $height))), __LINE__);
        }
        $this->height = $height;
        return $this;
    }
    /**
     * Get volume value
     * @return float|null
     */
    public function getVolume()
    {
        return $this->volume;
    }
    /**
     * Set volume value
     * @param float $volume
     * @return \DBSchenker\StructType\PackageLineType
     */
    public function setVolume($volume = null)
    {
        // validation for constraint: float
        if (!is_null($volume) && !(is_float($volume) || is_numeric($volume))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($volume, true), gettype($volume)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($volume) && mb_strlen(mb_substr($volume, false !== mb_strpos($volume, '.') ? mb_strpos($volume, '.') + 1 : mb_strlen($volume))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($volume, true), mb_strlen(mb_substr($volume, mb_strpos($volume, '.') + 1))), __LINE__);
        }
        // validation for constraint: minExclusive
        if (!is_null($volume) && $volume <= 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than 0', var_export($volume, true)), __LINE__);
        }
        // validation for constraint: pattern([^\.]*(\.[0-9]{1,3})?)
        if (!is_null($volume) && !preg_match('/[^\\.]*(\\.[0-9]{1,3})?/', $volume)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [^\.]*(\.[0-9]{1,3})?', var_export($volume, true)), __LINE__);
        }
        // validation for constraint: totalDigits(11)
        if (!is_null($volume) && mb_strlen(preg_replace('/(\D)/', '', $volume)) > 11) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 11 digits, "%d" given', var_export($volume, true), mb_strlen(preg_replace('/(\D)/', '', $volume))), __LINE__);
        }
        $this->volume = $volume;
        return $this;
    }
    /**
     * Get grossWeight value
     * @return float|null
     */
    public function getGrossWeight()
    {
        return $this->grossWeight;
    }
    /**
     * Set grossWeight value
     * @param float $grossWeight
     * @return \DBSchenker\StructType\PackageLineType
     */
    public function setGrossWeight($grossWeight = null)
    {
        // validation for constraint: float
        if (!is_null($grossWeight) && !(is_float($grossWeight) || is_numeric($grossWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($grossWeight, true), gettype($grossWeight)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($grossWeight) && mb_strlen(mb_substr($grossWeight, false !== mb_strpos($grossWeight, '.') ? mb_strpos($grossWeight, '.') + 1 : mb_strlen($grossWeight))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($grossWeight, true), mb_strlen(mb_substr($grossWeight, mb_strpos($grossWeight, '.') + 1))), __LINE__);
        }
        // validation for constraint: minExclusive
        if (!is_null($grossWeight) && $grossWeight <= 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than 0', var_export($grossWeight, true)), __LINE__);
        }
        // validation for constraint: pattern([^\.]*(\.[0-9]{1,2})?)
        if (!is_null($grossWeight) && !preg_match('/[^\\.]*(\\.[0-9]{1,2})?/', $grossWeight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [^\.]*(\.[0-9]{1,2})?', var_export($grossWeight, true)), __LINE__);
        }
        // validation for constraint: totalDigits(10)
        if (!is_null($grossWeight) && mb_strlen(preg_replace('/(\D)/', '', $grossWeight)) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 10 digits, "%d" given', var_export($grossWeight, true), mb_strlen(preg_replace('/(\D)/', '', $grossWeight))), __LINE__);
        }
        $this->grossWeight = $grossWeight;
        return $this;
    }
}
