<?php

namespace DBSchenker\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for loadSecuringEquipmentType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines load securing equipment type
 * @subpackage Structs
 */
class LoadSecuringEquipmentType extends AbstractStructBase
{
    /**
     * The type
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $type;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - documentation: Defines equipment quantity
     * - minOccurs: 1
     * @var int
     */
    public $quantity;
    /**
     * Constructor method for loadSecuringEquipmentType
     * @uses LoadSecuringEquipmentType::setType()
     * @uses LoadSecuringEquipmentType::setQuantity()
     * @param string $type
     * @param int $quantity
     */
    public function __construct($type = null, $quantity = null)
    {
        $this
            ->setType($type)
            ->setQuantity($quantity);
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \DBSchenker\EnumType\Type::valueIsValid()
     * @uses \DBSchenker\EnumType\Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \DBSchenker\StructType\LoadSecuringEquipmentType
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\DBSchenker\EnumType\Type::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DBSchenker\EnumType\Type', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \DBSchenker\EnumType\Type::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get quantity value
     * @return int
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param int $quantity
     * @return \DBSchenker\StructType\LoadSecuringEquipmentType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
}
