<?php

namespace DBSchenker\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for fileType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines file type
 * @subpackage Structs
 */
class FileType extends AbstractStructBase
{
    /**
     * The fileSizeBytes
     * Meta information extracted from the WSDL
     * - documentation: Defines file size in bytes
     * @var int
     */
    public $fileSizeBytes;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: Specifies file name
     * - base: xs:string
     * - maxLength: 250
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 5
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The typeOfDocument
     * Meta information extracted from the WSDL
     * - documentation: holds type of document
     * - minOccurs: 0
     * @var string
     */
    public $typeOfDocument;
    /**
     * The data
     * Meta information extracted from the WSDL
     * - documentation: Holds Base64 data of the file (max. 6Mb)
     * - minOccurs: 0
     * @var string
     */
    public $data;
    /**
     * Constructor method for fileType
     * @uses FileType::setFileSizeBytes()
     * @uses FileType::setName()
     * @uses FileType::setType()
     * @uses FileType::setTypeOfDocument()
     * @uses FileType::setData()
     * @param int $fileSizeBytes
     * @param string $name
     * @param string $type
     * @param string $typeOfDocument
     * @param string $data
     */
    public function __construct($fileSizeBytes = null, $name = null, $type = null, $typeOfDocument = null, $data = null)
    {
        $this
            ->setFileSizeBytes($fileSizeBytes)
            ->setName($name)
            ->setType($type)
            ->setTypeOfDocument($typeOfDocument)
            ->setData($data);
    }
    /**
     * Get fileSizeBytes value
     * @return int|null
     */
    public function getFileSizeBytes()
    {
        return $this->fileSizeBytes;
    }
    /**
     * Set fileSizeBytes value
     * @param int $fileSizeBytes
     * @return \DBSchenker\StructType\FileType
     */
    public function setFileSizeBytes($fileSizeBytes = null)
    {
        // validation for constraint: int
        if (!is_null($fileSizeBytes) && !(is_int($fileSizeBytes) || ctype_digit($fileSizeBytes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fileSizeBytes, true), gettype($fileSizeBytes)), __LINE__);
        }
        $this->fileSizeBytes = $fileSizeBytes;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \DBSchenker\StructType\FileType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(250)
        if (!is_null($name) && mb_strlen($name) > 250) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 250', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \DBSchenker\EnumType\Type::valueIsValid()
     * @uses \DBSchenker\EnumType\Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \DBSchenker\StructType\FileType
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\DBSchenker\EnumType\Type::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DBSchenker\EnumType\Type', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \DBSchenker\EnumType\Type::getValidValues())), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($type) && mb_strlen($type) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get typeOfDocument value
     * @return string|null
     */
    public function getTypeOfDocument()
    {
        return $this->typeOfDocument;
    }
    /**
     * Set typeOfDocument value
     * @uses \DBSchenker\EnumType\FileTypeOfDocumentType::valueIsValid()
     * @uses \DBSchenker\EnumType\FileTypeOfDocumentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeOfDocument
     * @return \DBSchenker\StructType\FileType
     */
    public function setTypeOfDocument($typeOfDocument = null)
    {
        // validation for constraint: enumeration
        if (!\DBSchenker\EnumType\FileTypeOfDocumentType::valueIsValid($typeOfDocument)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DBSchenker\EnumType\FileTypeOfDocumentType', is_array($typeOfDocument) ? implode(', ', $typeOfDocument) : var_export($typeOfDocument, true), implode(', ', \DBSchenker\EnumType\FileTypeOfDocumentType::getValidValues())), __LINE__);
        }
        $this->typeOfDocument = $typeOfDocument;
        return $this;
    }
    /**
     * Get data value
     * @return string|null
     */
    public function getData()
    {
        return $this->data;
    }
    /**
     * Set data value
     * @param string $data
     * @return \DBSchenker\StructType\FileType
     */
    public function setData($data = null)
    {
        // validation for constraint: string
        if (!is_null($data) && !is_string($data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($data, true), gettype($data)), __LINE__);
        }
        $this->data = $data;
        return $this;
    }
}
