<?php

namespace DBSchenker\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for externalBookingResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: Holds the in tag of the "create booking" operation response
 * @subpackage Structs
 */
class ExternalBookingResponse extends AbstractStructBase
{
    /**
     * The applicationArea
     * Meta information extracted from the WSDL
     * - documentation: Holds access request ID of the request, which will be returned with response
     * - minOccurs: 1
     * @var \DBSchenker\StructType\ApplicationAreaResponse
     */
    public $applicationArea;
    /**
     * The bookingId
     * Meta information extracted from the WSDL
     * - documentation: Holds response booking ID
     * - base: xs:string
     * - minOccurs: 0
     * - pattern: [\d]{6}-[\d]{6}
     * @var string
     */
    public $bookingId;
    /**
     * The barcodeReference
     * Meta information extracted from the WSDL
     * - documentation: Holds list of barcode references
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \DBSchenker\StructType\BarcodeReferenceType[]
     */
    public $barcodeReference;
    /**
     * The barcodeDocument
     * Meta information extracted from the WSDL
     * - documentation: Holds the barcode labels for the booking
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $barcodeDocument;
    /**
     * Constructor method for externalBookingResponse
     * @uses ExternalBookingResponse::setApplicationArea()
     * @uses ExternalBookingResponse::setBookingId()
     * @uses ExternalBookingResponse::setBarcodeReference()
     * @uses ExternalBookingResponse::setBarcodeDocument()
     * @param \DBSchenker\StructType\ApplicationAreaResponse $applicationArea
     * @param string $bookingId
     * @param \DBSchenker\StructType\BarcodeReferenceType[] $barcodeReference
     * @param string $barcodeDocument
     */
    public function __construct(\DBSchenker\StructType\ApplicationAreaResponse $applicationArea = null, $bookingId = null, array $barcodeReference = array(), $barcodeDocument = null)
    {
        $this
            ->setApplicationArea($applicationArea)
            ->setBookingId($bookingId)
            ->setBarcodeReference($barcodeReference)
            ->setBarcodeDocument($barcodeDocument);
    }
    /**
     * Get applicationArea value
     * @return \DBSchenker\StructType\ApplicationAreaResponse
     */
    public function getApplicationArea()
    {
        return $this->applicationArea;
    }
    /**
     * Set applicationArea value
     * @param \DBSchenker\StructType\ApplicationAreaResponse $applicationArea
     * @return \DBSchenker\StructType\ExternalBookingResponse
     */
    public function setApplicationArea(\DBSchenker\StructType\ApplicationAreaResponse $applicationArea = null)
    {
        $this->applicationArea = $applicationArea;
        return $this;
    }
    /**
     * Get bookingId value
     * @return string|null
     */
    public function getBookingId()
    {
        return $this->bookingId;
    }
    /**
     * Set bookingId value
     * @param string $bookingId
     * @return \DBSchenker\StructType\ExternalBookingResponse
     */
    public function setBookingId($bookingId = null)
    {
        // validation for constraint: string
        if (!is_null($bookingId) && !is_string($bookingId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingId, true), gettype($bookingId)), __LINE__);
        }
        // validation for constraint: pattern([\d]{6}-[\d]{6})
        if (!is_null($bookingId) && !preg_match('/[\\d]{6}-[\\d]{6}/', $bookingId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\d]{6}-[\d]{6}', var_export($bookingId, true)), __LINE__);
        }
        $this->bookingId = $bookingId;
        return $this;
    }
    /**
     * Get barcodeReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \DBSchenker\StructType\BarcodeReferenceType[]|null
     */
    public function getBarcodeReference()
    {
        return isset($this->barcodeReference) ? $this->barcodeReference : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBarcodeReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBarcodeReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBarcodeReferenceForArrayConstraintsFromSetBarcodeReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $externalBookingResponseBarcodeReferenceItem) {
            // validation for constraint: itemType
            if (!$externalBookingResponseBarcodeReferenceItem instanceof \DBSchenker\StructType\BarcodeReferenceType) {
                $invalidValues[] = is_object($externalBookingResponseBarcodeReferenceItem) ? get_class($externalBookingResponseBarcodeReferenceItem) : sprintf('%s(%s)', gettype($externalBookingResponseBarcodeReferenceItem), var_export($externalBookingResponseBarcodeReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The barcodeReference property can only contain items of type \DBSchenker\StructType\BarcodeReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set barcodeReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \DBSchenker\StructType\BarcodeReferenceType[] $barcodeReference
     * @return \DBSchenker\StructType\ExternalBookingResponse
     */
    public function setBarcodeReference(array $barcodeReference = array())
    {
        // validation for constraint: array
        if ('' !== ($barcodeReferenceArrayErrorMessage = self::validateBarcodeReferenceForArrayConstraintsFromSetBarcodeReference($barcodeReference))) {
            throw new \InvalidArgumentException($barcodeReferenceArrayErrorMessage, __LINE__);
        }
        if (is_null($barcodeReference) || (is_array($barcodeReference) && empty($barcodeReference))) {
            unset($this->barcodeReference);
        } else {
            $this->barcodeReference = $barcodeReference;
        }
        return $this;
    }
    /**
     * Add item to barcodeReference value
     * @throws \InvalidArgumentException
     * @param \DBSchenker\StructType\BarcodeReferenceType $item
     * @return \DBSchenker\StructType\ExternalBookingResponse
     */
    public function addToBarcodeReference(\DBSchenker\StructType\BarcodeReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \DBSchenker\StructType\BarcodeReferenceType) {
            throw new \InvalidArgumentException(sprintf('The barcodeReference property can only contain items of type \DBSchenker\StructType\BarcodeReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->barcodeReference[] = $item;
        return $this;
    }
    /**
     * Get barcodeDocument value
     * @return string|null
     */
    public function getBarcodeDocument()
    {
        return $this->barcodeDocument;
    }
    /**
     * Set barcodeDocument value
     * @param string $barcodeDocument
     * @return \DBSchenker\StructType\ExternalBookingResponse
     */
    public function setBarcodeDocument($barcodeDocument = null)
    {
        // validation for constraint: string
        if (!is_null($barcodeDocument) && !is_string($barcodeDocument)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcodeDocument, true), gettype($barcodeDocument)), __LINE__);
        }
        $this->barcodeDocument = $barcodeDocument;
        return $this;
    }
}
