<?php

namespace DBSchenker\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for deliveryPreNoticeSmsType StructType
 * Meta information extracted from the WSDL
 * - documentation: Holds delivery pre-notice sms information.
 * @subpackage Structs
 */
class DeliveryPreNoticeSmsType extends AbstractStructBase
{
    /**
     * The contact
     * Meta information extracted from the WSDL
     * - documentation: Defines contact | The contact person's name.
     * - base: xs:string
     * - maxLength: 500
     * @var string
     */
    public $contact;
    /**
     * The phone
     * Meta information extracted from the WSDL
     * - documentation: Defines phone | Defines contact phone | The contact person's phone number.
     * - base: xs:string
     * - maxLength: 250
     * @var string
     */
    public $phone;
    /**
     * Constructor method for deliveryPreNoticeSmsType
     * @uses DeliveryPreNoticeSmsType::setContact()
     * @uses DeliveryPreNoticeSmsType::setPhone()
     * @param string $contact
     * @param string $phone
     */
    public function __construct($contact = null, $phone = null)
    {
        $this
            ->setContact($contact)
            ->setPhone($phone);
    }
    /**
     * Get contact value
     * @return string|null
     */
    public function getContact()
    {
        return $this->contact;
    }
    /**
     * Set contact value
     * @param string $contact
     * @return \DBSchenker\StructType\DeliveryPreNoticeSmsType
     */
    public function setContact($contact = null)
    {
        // validation for constraint: string
        if (!is_null($contact) && !is_string($contact)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contact, true), gettype($contact)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($contact) && mb_strlen($contact) > 500) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen($contact)), __LINE__);
        }
        $this->contact = $contact;
        return $this;
    }
    /**
     * Get phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \DBSchenker\StructType\DeliveryPreNoticeSmsType
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        // validation for constraint: maxLength(250)
        if (!is_null($phone) && mb_strlen($phone) > 250) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 250', mb_strlen($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
}
