<?php

namespace DBSchenker\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for deliveryDateConsignee StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines Delivery Date Consignee
 * @subpackage Structs
 */
class DeliveryDateConsignee extends AbstractStructBase
{
    /**
     * The deliveryDate
     * Meta information extracted from the WSDL
     * - documentation: Defines delivery date consignee
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $deliveryDate;
    /**
     * The deliveryType
     * Meta information extracted from the WSDL
     * - documentation: Defines delivery date consignee type: LATEST, EARLIEST, FIX or TIME
     * - minOccurs: 0
     * @var string
     */
    public $deliveryType;
    /**
     * The timeFrom
     * Meta information extracted from the WSDL
     * - documentation: Defines delivery date consignee time FROM (00:00 upto 23:59) when type TIME is selected
     * - base: xs:string
     * - minOccurs: 0
     * - pattern: (([01][0-9])|(2[0-3])):[0-5][0-9]
     * @var string
     */
    public $timeFrom;
    /**
     * The timeTo
     * Meta information extracted from the WSDL
     * - documentation: Defines delivery date consignee time TO (00:00 upto 23:59) when type TIME is selected
     * - base: xs:string
     * - minOccurs: 0
     * - pattern: (([01][0-9])|(2[0-3])):[0-5][0-9]
     * @var string
     */
    public $timeTo;
    /**
     * Constructor method for deliveryDateConsignee
     * @uses DeliveryDateConsignee::setDeliveryDate()
     * @uses DeliveryDateConsignee::setDeliveryType()
     * @uses DeliveryDateConsignee::setTimeFrom()
     * @uses DeliveryDateConsignee::setTimeTo()
     * @param string $deliveryDate
     * @param string $deliveryType
     * @param string $timeFrom
     * @param string $timeTo
     */
    public function __construct($deliveryDate = null, $deliveryType = null, $timeFrom = null, $timeTo = null)
    {
        $this
            ->setDeliveryDate($deliveryDate)
            ->setDeliveryType($deliveryType)
            ->setTimeFrom($timeFrom)
            ->setTimeTo($timeTo);
    }
    /**
     * Get deliveryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveryDate()
    {
        return isset($this->deliveryDate) ? $this->deliveryDate : null;
    }
    /**
     * Set deliveryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliveryDate
     * @return \DBSchenker\StructType\DeliveryDateConsignee
     */
    public function setDeliveryDate($deliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDate) && !is_string($deliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryDate, true), gettype($deliveryDate)), __LINE__);
        }
        if (is_null($deliveryDate) || (is_array($deliveryDate) && empty($deliveryDate))) {
            unset($this->deliveryDate);
        } else {
            $this->deliveryDate = $deliveryDate;
        }
        return $this;
    }
    /**
     * Get deliveryType value
     * @return string|null
     */
    public function getDeliveryType()
    {
        return $this->deliveryType;
    }
    /**
     * Set deliveryType value
     * @uses \DBSchenker\EnumType\DeliveryDateConsigneeType::valueIsValid()
     * @uses \DBSchenker\EnumType\DeliveryDateConsigneeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deliveryType
     * @return \DBSchenker\StructType\DeliveryDateConsignee
     */
    public function setDeliveryType($deliveryType = null)
    {
        // validation for constraint: enumeration
        if (!\DBSchenker\EnumType\DeliveryDateConsigneeType::valueIsValid($deliveryType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DBSchenker\EnumType\DeliveryDateConsigneeType', is_array($deliveryType) ? implode(', ', $deliveryType) : var_export($deliveryType, true), implode(', ', \DBSchenker\EnumType\DeliveryDateConsigneeType::getValidValues())), __LINE__);
        }
        $this->deliveryType = $deliveryType;
        return $this;
    }
    /**
     * Get timeFrom value
     * @return string|null
     */
    public function getTimeFrom()
    {
        return $this->timeFrom;
    }
    /**
     * Set timeFrom value
     * @param string $timeFrom
     * @return \DBSchenker\StructType\DeliveryDateConsignee
     */
    public function setTimeFrom($timeFrom = null)
    {
        // validation for constraint: string
        if (!is_null($timeFrom) && !is_string($timeFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeFrom, true), gettype($timeFrom)), __LINE__);
        }
        // validation for constraint: pattern((([01][0-9])|(2[0-3])):[0-5][0-9])
        if (!is_null($timeFrom) && !preg_match('/(([01][0-9])|(2[0-3])):[0-5][0-9]/', $timeFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (([01][0-9])|(2[0-3])):[0-5][0-9]', var_export($timeFrom, true)), __LINE__);
        }
        $this->timeFrom = $timeFrom;
        return $this;
    }
    /**
     * Get timeTo value
     * @return string|null
     */
    public function getTimeTo()
    {
        return $this->timeTo;
    }
    /**
     * Set timeTo value
     * @param string $timeTo
     * @return \DBSchenker\StructType\DeliveryDateConsignee
     */
    public function setTimeTo($timeTo = null)
    {
        // validation for constraint: string
        if (!is_null($timeTo) && !is_string($timeTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeTo, true), gettype($timeTo)), __LINE__);
        }
        // validation for constraint: pattern((([01][0-9])|(2[0-3])):[0-5][0-9])
        if (!is_null($timeTo) && !preg_match('/(([01][0-9])|(2[0-3])):[0-5][0-9]/', $timeTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (([01][0-9])|(2[0-3])):[0-5][0-9]', var_export($timeTo, true)), __LINE__);
        }
        $this->timeTo = $timeTo;
        return $this;
    }
}
