<?php

namespace DBSchenker\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for dangerousGoodsUnNoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Holds dangerous goods UnNo number
 * @subpackage Structs
 */
class DangerousGoodsUnNoType extends AbstractStructBase
{
    /**
     * The unNo
     * Meta information extracted from the WSDL
     * - documentation: Specifies dangerous goods UnNo number
     * - base: xs:string
     * - maxLength: 4
     * - minOccurs: 1
     * @var string
     */
    public $unNo;
    /**
     * The labelType
     * Meta information extracted from the WSDL
     * - documentation: Holds dangerous goods label type: LN_1, LN_1_4, LN_2_1, LN_2_2, LN_2_3, LN_3, LN_4_1, LN_4_2, LN_4_3, LN_5_1, LN_5_2, LN_6_1, LN_6_2, LN_7, LN_8, LN_9, LN_LQ
     * - base: xs:string
     * - maxLength: 10
     * - minOccurs: 1
     * @var string
     */
    public $labelType;
    /**
     * The packageGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $packageGroup;
    /**
     * The shippingName
     * Meta information extracted from the WSDL
     * - documentation: Specifies dangerous goods shipping name
     * - base: xs:string
     * - maxLength: 250
     * - minOccurs: 1
     * @var string
     */
    public $shippingName;
    /**
     * The technicalName
     * Meta information extracted from the WSDL
     * - documentation: Specifies dangerous goods technical name
     * - base: xs:string
     * - maxLength: 250
     * - minOccurs: 0
     * @var string
     */
    public $technicalName;
    /**
     * The specialProvision
     * Meta information extracted from the WSDL
     * - documentation: Specifies dangerous goods special provision
     * - base: xs:string
     * - maxLength: 250
     * - minOccurs: 0
     * @var string
     */
    public $specialProvision;
    /**
     * The tunnelCode
     * Meta information extracted from the WSDL
     * - documentation: Specifies dangerous goods technical code
     * - base: xs:string
     * - maxLength: 10
     * - minOccurs: 0
     * @var string
     */
    public $tunnelCode;
    /**
     * The waste
     * Meta information extracted from the WSDL
     * - documentation: Specifies if dangerous goods are waste
     * @var bool
     */
    public $waste;
    /**
     * The europeanWasteCode
     * Meta information extracted from the WSDL
     * - documentation: Defines european waste code if 'waste' is set to true
     * - minOccurs: 0
     * @var string
     */
    public $europeanWasteCode;
    /**
     * The NEM
     * Meta information extracted from the WSDL
     * - documentation: Specifies dangerous goods NEM weight
     * - minOccurs: 0
     * @var string
     */
    public $NEM;
    /**
     * The exceptedQuantities
     * Meta information extracted from the WSDL
     * - documentation: Specifies if dangerous goods are of excepted quantities
     * @var bool
     */
    public $exceptedQuantities;
    /**
     * The limitedQuantity
     * Meta information extracted from the WSDL
     * - documentation: Specifies if dangerous goods are of limited quantity
     * @var bool
     */
    public $limitedQuantity;
    /**
     * The emptyUncleanedPackages
     * Meta information extracted from the WSDL
     * - documentation: Specifies if dangerous goods are of empty uncleaned packages
     * - minOccurs: 0
     * @var bool
     */
    public $emptyUncleanedPackages;
    /**
     * The marinePollutant
     * Meta information extracted from the WSDL
     * - documentation: Specifies if dangerous goods are marine pollutant
     * @var bool
     */
    public $marinePollutant;
    /**
     * Constructor method for dangerousGoodsUnNoType
     * @uses DangerousGoodsUnNoType::setUnNo()
     * @uses DangerousGoodsUnNoType::setLabelType()
     * @uses DangerousGoodsUnNoType::setPackageGroup()
     * @uses DangerousGoodsUnNoType::setShippingName()
     * @uses DangerousGoodsUnNoType::setTechnicalName()
     * @uses DangerousGoodsUnNoType::setSpecialProvision()
     * @uses DangerousGoodsUnNoType::setTunnelCode()
     * @uses DangerousGoodsUnNoType::setWaste()
     * @uses DangerousGoodsUnNoType::setEuropeanWasteCode()
     * @uses DangerousGoodsUnNoType::setNEM()
     * @uses DangerousGoodsUnNoType::setExceptedQuantities()
     * @uses DangerousGoodsUnNoType::setLimitedQuantity()
     * @uses DangerousGoodsUnNoType::setEmptyUncleanedPackages()
     * @uses DangerousGoodsUnNoType::setMarinePollutant()
     * @param string $unNo
     * @param string $labelType
     * @param string $packageGroup
     * @param string $shippingName
     * @param string $technicalName
     * @param string $specialProvision
     * @param string $tunnelCode
     * @param bool $waste
     * @param string $europeanWasteCode
     * @param string $nEM
     * @param bool $exceptedQuantities
     * @param bool $limitedQuantity
     * @param bool $emptyUncleanedPackages
     * @param bool $marinePollutant
     */
    public function __construct($unNo = null, $labelType = null, $packageGroup = null, $shippingName = null, $technicalName = null, $specialProvision = null, $tunnelCode = null, $waste = null, $europeanWasteCode = null, $nEM = null, $exceptedQuantities = null, $limitedQuantity = null, $emptyUncleanedPackages = null, $marinePollutant = null)
    {
        $this
            ->setUnNo($unNo)
            ->setLabelType($labelType)
            ->setPackageGroup($packageGroup)
            ->setShippingName($shippingName)
            ->setTechnicalName($technicalName)
            ->setSpecialProvision($specialProvision)
            ->setTunnelCode($tunnelCode)
            ->setWaste($waste)
            ->setEuropeanWasteCode($europeanWasteCode)
            ->setNEM($nEM)
            ->setExceptedQuantities($exceptedQuantities)
            ->setLimitedQuantity($limitedQuantity)
            ->setEmptyUncleanedPackages($emptyUncleanedPackages)
            ->setMarinePollutant($marinePollutant);
    }
    /**
     * Get unNo value
     * @return string
     */
    public function getUnNo()
    {
        return $this->unNo;
    }
    /**
     * Set unNo value
     * @param string $unNo
     * @return \DBSchenker\StructType\DangerousGoodsUnNoType
     */
    public function setUnNo($unNo = null)
    {
        // validation for constraint: string
        if (!is_null($unNo) && !is_string($unNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unNo, true), gettype($unNo)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($unNo) && mb_strlen($unNo) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($unNo)), __LINE__);
        }
        $this->unNo = $unNo;
        return $this;
    }
    /**
     * Get labelType value
     * @return string
     */
    public function getLabelType()
    {
        return $this->labelType;
    }
    /**
     * Set labelType value
     * @param string $labelType
     * @return \DBSchenker\StructType\DangerousGoodsUnNoType
     */
    public function setLabelType($labelType = null)
    {
        // validation for constraint: string
        if (!is_null($labelType) && !is_string($labelType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($labelType, true), gettype($labelType)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($labelType) && mb_strlen($labelType) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($labelType)), __LINE__);
        }
        $this->labelType = $labelType;
        return $this;
    }
    /**
     * Get packageGroup value
     * @return string
     */
    public function getPackageGroup()
    {
        return $this->packageGroup;
    }
    /**
     * Set packageGroup value
     * @uses \DBSchenker\EnumType\PackageGroup::valueIsValid()
     * @uses \DBSchenker\EnumType\PackageGroup::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packageGroup
     * @return \DBSchenker\StructType\DangerousGoodsUnNoType
     */
    public function setPackageGroup($packageGroup = null)
    {
        // validation for constraint: enumeration
        if (!\DBSchenker\EnumType\PackageGroup::valueIsValid($packageGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DBSchenker\EnumType\PackageGroup', is_array($packageGroup) ? implode(', ', $packageGroup) : var_export($packageGroup, true), implode(', ', \DBSchenker\EnumType\PackageGroup::getValidValues())), __LINE__);
        }
        $this->packageGroup = $packageGroup;
        return $this;
    }
    /**
     * Get shippingName value
     * @return string
     */
    public function getShippingName()
    {
        return $this->shippingName;
    }
    /**
     * Set shippingName value
     * @param string $shippingName
     * @return \DBSchenker\StructType\DangerousGoodsUnNoType
     */
    public function setShippingName($shippingName = null)
    {
        // validation for constraint: string
        if (!is_null($shippingName) && !is_string($shippingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingName, true), gettype($shippingName)), __LINE__);
        }
        // validation for constraint: maxLength(250)
        if (!is_null($shippingName) && mb_strlen($shippingName) > 250) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 250', mb_strlen($shippingName)), __LINE__);
        }
        $this->shippingName = $shippingName;
        return $this;
    }
    /**
     * Get technicalName value
     * @return string|null
     */
    public function getTechnicalName()
    {
        return $this->technicalName;
    }
    /**
     * Set technicalName value
     * @param string $technicalName
     * @return \DBSchenker\StructType\DangerousGoodsUnNoType
     */
    public function setTechnicalName($technicalName = null)
    {
        // validation for constraint: string
        if (!is_null($technicalName) && !is_string($technicalName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($technicalName, true), gettype($technicalName)), __LINE__);
        }
        // validation for constraint: maxLength(250)
        if (!is_null($technicalName) && mb_strlen($technicalName) > 250) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 250', mb_strlen($technicalName)), __LINE__);
        }
        $this->technicalName = $technicalName;
        return $this;
    }
    /**
     * Get specialProvision value
     * @return string|null
     */
    public function getSpecialProvision()
    {
        return $this->specialProvision;
    }
    /**
     * Set specialProvision value
     * @param string $specialProvision
     * @return \DBSchenker\StructType\DangerousGoodsUnNoType
     */
    public function setSpecialProvision($specialProvision = null)
    {
        // validation for constraint: string
        if (!is_null($specialProvision) && !is_string($specialProvision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specialProvision, true), gettype($specialProvision)), __LINE__);
        }
        // validation for constraint: maxLength(250)
        if (!is_null($specialProvision) && mb_strlen($specialProvision) > 250) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 250', mb_strlen($specialProvision)), __LINE__);
        }
        $this->specialProvision = $specialProvision;
        return $this;
    }
    /**
     * Get tunnelCode value
     * @return string|null
     */
    public function getTunnelCode()
    {
        return $this->tunnelCode;
    }
    /**
     * Set tunnelCode value
     * @param string $tunnelCode
     * @return \DBSchenker\StructType\DangerousGoodsUnNoType
     */
    public function setTunnelCode($tunnelCode = null)
    {
        // validation for constraint: string
        if (!is_null($tunnelCode) && !is_string($tunnelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tunnelCode, true), gettype($tunnelCode)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($tunnelCode) && mb_strlen($tunnelCode) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($tunnelCode)), __LINE__);
        }
        $this->tunnelCode = $tunnelCode;
        return $this;
    }
    /**
     * Get waste value
     * @return bool|null
     */
    public function getWaste()
    {
        return $this->waste;
    }
    /**
     * Set waste value
     * @param bool $waste
     * @return \DBSchenker\StructType\DangerousGoodsUnNoType
     */
    public function setWaste($waste = null)
    {
        // validation for constraint: boolean
        if (!is_null($waste) && !is_bool($waste)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($waste, true), gettype($waste)), __LINE__);
        }
        $this->waste = $waste;
        return $this;
    }
    /**
     * Get europeanWasteCode value
     * @return string|null
     */
    public function getEuropeanWasteCode()
    {
        return $this->europeanWasteCode;
    }
    /**
     * Set europeanWasteCode value
     * @param string $europeanWasteCode
     * @return \DBSchenker\StructType\DangerousGoodsUnNoType
     */
    public function setEuropeanWasteCode($europeanWasteCode = null)
    {
        // validation for constraint: string
        if (!is_null($europeanWasteCode) && !is_string($europeanWasteCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($europeanWasteCode, true), gettype($europeanWasteCode)), __LINE__);
        }
        $this->europeanWasteCode = $europeanWasteCode;
        return $this;
    }
    /**
     * Get NEM value
     * @return string|null
     */
    public function getNEM()
    {
        return $this->NEM;
    }
    /**
     * Set NEM value
     * @param string $nEM
     * @return \DBSchenker\StructType\DangerousGoodsUnNoType
     */
    public function setNEM($nEM = null)
    {
        // validation for constraint: string
        if (!is_null($nEM) && !is_string($nEM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nEM, true), gettype($nEM)), __LINE__);
        }
        $this->NEM = $nEM;
        return $this;
    }
    /**
     * Get exceptedQuantities value
     * @return bool|null
     */
    public function getExceptedQuantities()
    {
        return $this->exceptedQuantities;
    }
    /**
     * Set exceptedQuantities value
     * @param bool $exceptedQuantities
     * @return \DBSchenker\StructType\DangerousGoodsUnNoType
     */
    public function setExceptedQuantities($exceptedQuantities = null)
    {
        // validation for constraint: boolean
        if (!is_null($exceptedQuantities) && !is_bool($exceptedQuantities)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exceptedQuantities, true), gettype($exceptedQuantities)), __LINE__);
        }
        $this->exceptedQuantities = $exceptedQuantities;
        return $this;
    }
    /**
     * Get limitedQuantity value
     * @return bool|null
     */
    public function getLimitedQuantity()
    {
        return $this->limitedQuantity;
    }
    /**
     * Set limitedQuantity value
     * @param bool $limitedQuantity
     * @return \DBSchenker\StructType\DangerousGoodsUnNoType
     */
    public function setLimitedQuantity($limitedQuantity = null)
    {
        // validation for constraint: boolean
        if (!is_null($limitedQuantity) && !is_bool($limitedQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($limitedQuantity, true), gettype($limitedQuantity)), __LINE__);
        }
        $this->limitedQuantity = $limitedQuantity;
        return $this;
    }
    /**
     * Get emptyUncleanedPackages value
     * @return bool|null
     */
    public function getEmptyUncleanedPackages()
    {
        return $this->emptyUncleanedPackages;
    }
    /**
     * Set emptyUncleanedPackages value
     * @param bool $emptyUncleanedPackages
     * @return \DBSchenker\StructType\DangerousGoodsUnNoType
     */
    public function setEmptyUncleanedPackages($emptyUncleanedPackages = null)
    {
        // validation for constraint: boolean
        if (!is_null($emptyUncleanedPackages) && !is_bool($emptyUncleanedPackages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($emptyUncleanedPackages, true), gettype($emptyUncleanedPackages)), __LINE__);
        }
        $this->emptyUncleanedPackages = $emptyUncleanedPackages;
        return $this;
    }
    /**
     * Get marinePollutant value
     * @return bool|null
     */
    public function getMarinePollutant()
    {
        return $this->marinePollutant;
    }
    /**
     * Set marinePollutant value
     * @param bool $marinePollutant
     * @return \DBSchenker\StructType\DangerousGoodsUnNoType
     */
    public function setMarinePollutant($marinePollutant = null)
    {
        // validation for constraint: boolean
        if (!is_null($marinePollutant) && !is_bool($marinePollutant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($marinePollutant, true), gettype($marinePollutant)), __LINE__);
        }
        $this->marinePollutant = $marinePollutant;
        return $this;
    }
}
