<?php

namespace DBSchenker\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for customsDeclarant StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines Customs Declarant
 * @subpackage Structs
 */
class CustomsDeclarant extends AbstractStructBase
{
    /**
     * The type
     * Meta information extracted from the WSDL
     * - documentation: Defines Customs Declarant type
     * - minOccurs: 1
     * @var string
     */
    public $type;
    /**
     * The declarantInformation
     * Meta information extracted from the WSDL
     * - documentation: Specifies declarant Information details
     * - minOccurs: 0
     * @var \DBSchenker\StructType\DeclarantInformation
     */
    public $declarantInformation;
    /**
     * Constructor method for customsDeclarant
     * @uses CustomsDeclarant::setType()
     * @uses CustomsDeclarant::setDeclarantInformation()
     * @param string $type
     * @param \DBSchenker\StructType\DeclarantInformation $declarantInformation
     */
    public function __construct($type = null, \DBSchenker\StructType\DeclarantInformation $declarantInformation = null)
    {
        $this
            ->setType($type)
            ->setDeclarantInformation($declarantInformation);
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \DBSchenker\EnumType\CustomsDeclarantType::valueIsValid()
     * @uses \DBSchenker\EnumType\CustomsDeclarantType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \DBSchenker\StructType\CustomsDeclarant
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\DBSchenker\EnumType\CustomsDeclarantType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DBSchenker\EnumType\CustomsDeclarantType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \DBSchenker\EnumType\CustomsDeclarantType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get declarantInformation value
     * @return \DBSchenker\StructType\DeclarantInformation|null
     */
    public function getDeclarantInformation()
    {
        return $this->declarantInformation;
    }
    /**
     * Set declarantInformation value
     * @param \DBSchenker\StructType\DeclarantInformation $declarantInformation
     * @return \DBSchenker\StructType\CustomsDeclarant
     */
    public function setDeclarantInformation(\DBSchenker\StructType\DeclarantInformation $declarantInformation = null)
    {
        $this->declarantInformation = $declarantInformation;
        return $this;
    }
}
