<?php

namespace DBSchenker\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for currency StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines currency like EUR, USD, YEN ... | Defines a value with a currency. For instance: 110 EUR
 * @subpackage Structs
 */
class Currency extends AbstractStructBase
{
    /**
     * The value
     * Meta information extracted from the WSDL
     * - documentation: Defines value - amount of money
     * - base: xs:decimal
     * - fractionDigits: 2
     * - minExclusive: 0
     * - minOccurs: 1
     * - pattern: [^\.]*(\.[0-9]{1,2})?
     * - totalDigits: 12
     * @var float
     */
    public $value;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - length: 3
     * - minOccurs: 1
     * @var string
     */
    public $currency;
    /**
     * Constructor method for currency
     * @uses Currency::setValue()
     * @uses Currency::setCurrency()
     * @param float $value
     * @param string $currency
     */
    public function __construct($value = null, $currency = null)
    {
        $this
            ->setValue($value)
            ->setCurrency($currency);
    }
    /**
     * Get value value
     * @return float
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param float $value
     * @return \DBSchenker\StructType\Currency
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($value) && mb_strlen(mb_substr($value, false !== mb_strpos($value, '.') ? mb_strpos($value, '.') + 1 : mb_strlen($value))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($value, true), mb_strlen(mb_substr($value, mb_strpos($value, '.') + 1))), __LINE__);
        }
        // validation for constraint: minExclusive
        if (!is_null($value) && $value <= 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than 0', var_export($value, true)), __LINE__);
        }
        // validation for constraint: pattern([^\.]*(\.[0-9]{1,2})?)
        if (!is_null($value) && !preg_match('/[^\\.]*(\\.[0-9]{1,2})?/', $value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [^\.]*(\.[0-9]{1,2})?', var_export($value, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($value) && mb_strlen(preg_replace('/(\D)/', '', $value)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($value, true), mb_strlen(preg_replace('/(\D)/', '', $value))), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Get currency value
     * @return string
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \DBSchenker\StructType\Currency
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        // validation for constraint: length(3)
        if (!is_null($currency) && mb_strlen($currency) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 3', mb_strlen($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
}
