<?php

namespace DBSchenker\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for containerType StructType
 * Meta information extracted from the WSDL
 * - documentation: Holds container type | Defines container
 * @subpackage Structs
 */
class ContainerType extends AbstractStructBase
{
    /**
     * The positioningAddress
     * Meta information extracted from the WSDL
     * - documentation: Holds container positioning address
     * - minOccurs: 1
     * @var \DBSchenker\StructType\AddressType
     */
    public $positioningAddress;
    /**
     * The shippingInformation
     * Meta information extracted from the WSDL
     * - documentation: Holds container shipping information
     * - minOccurs: 1
     * @var \DBSchenker\StructType\ShippingInformationType
     */
    public $shippingInformation;
    /**
     * The containerType
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 50
     * - minOccurs: 0
     * @var string
     */
    public $containerType;
    /**
     * The containerNo
     * Meta information extracted from the WSDL
     * - documentation: Specifies container number
     * - base: xs:string
     * - maxLength: 100
     * - minOccurs: 0
     * @var string
     */
    public $containerNo;
    /**
     * The positioningDate
     * Meta information extracted from the WSDL
     * - documentation: Specifies container positioning date
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $positioningDate;
    /**
     * The sealNumber
     * Meta information extracted from the WSDL
     * - documentation: Specifies container seal number
     * - base: xs:string
     * - maxLength: 100
     * - minOccurs: 0
     * @var string
     */
    public $sealNumber;
    /**
     * Constructor method for containerType
     * @uses ContainerType::setPositioningAddress()
     * @uses ContainerType::setShippingInformation()
     * @uses ContainerType::setContainerType()
     * @uses ContainerType::setContainerNo()
     * @uses ContainerType::setPositioningDate()
     * @uses ContainerType::setSealNumber()
     * @param \DBSchenker\StructType\AddressType $positioningAddress
     * @param \DBSchenker\StructType\ShippingInformationType $shippingInformation
     * @param string $containerType
     * @param string $containerNo
     * @param string $positioningDate
     * @param string $sealNumber
     */
    public function __construct(\DBSchenker\StructType\AddressType $positioningAddress = null, \DBSchenker\StructType\ShippingInformationType $shippingInformation = null, $containerType = null, $containerNo = null, $positioningDate = null, $sealNumber = null)
    {
        $this
            ->setPositioningAddress($positioningAddress)
            ->setShippingInformation($shippingInformation)
            ->setContainerType($containerType)
            ->setContainerNo($containerNo)
            ->setPositioningDate($positioningDate)
            ->setSealNumber($sealNumber);
    }
    /**
     * Get positioningAddress value
     * @return \DBSchenker\StructType\AddressType
     */
    public function getPositioningAddress()
    {
        return $this->positioningAddress;
    }
    /**
     * Set positioningAddress value
     * @param \DBSchenker\StructType\AddressType $positioningAddress
     * @return \DBSchenker\StructType\ContainerType
     */
    public function setPositioningAddress(\DBSchenker\StructType\AddressType $positioningAddress = null)
    {
        $this->positioningAddress = $positioningAddress;
        return $this;
    }
    /**
     * Get shippingInformation value
     * @return \DBSchenker\StructType\ShippingInformationType
     */
    public function getShippingInformation()
    {
        return $this->shippingInformation;
    }
    /**
     * Set shippingInformation value
     * @param \DBSchenker\StructType\ShippingInformationType $shippingInformation
     * @return \DBSchenker\StructType\ContainerType
     */
    public function setShippingInformation(\DBSchenker\StructType\ShippingInformationType $shippingInformation = null)
    {
        $this->shippingInformation = $shippingInformation;
        return $this;
    }
    /**
     * Get containerType value
     * @return string|null
     */
    public function getContainerType()
    {
        return $this->containerType;
    }
    /**
     * Set containerType value
     * @param string $containerType
     * @return \DBSchenker\StructType\ContainerType
     */
    public function setContainerType($containerType = null)
    {
        // validation for constraint: string
        if (!is_null($containerType) && !is_string($containerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($containerType, true), gettype($containerType)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($containerType) && mb_strlen($containerType) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($containerType)), __LINE__);
        }
        $this->containerType = $containerType;
        return $this;
    }
    /**
     * Get containerNo value
     * @return string|null
     */
    public function getContainerNo()
    {
        return $this->containerNo;
    }
    /**
     * Set containerNo value
     * @param string $containerNo
     * @return \DBSchenker\StructType\ContainerType
     */
    public function setContainerNo($containerNo = null)
    {
        // validation for constraint: string
        if (!is_null($containerNo) && !is_string($containerNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($containerNo, true), gettype($containerNo)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($containerNo) && mb_strlen($containerNo) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($containerNo)), __LINE__);
        }
        $this->containerNo = $containerNo;
        return $this;
    }
    /**
     * Get positioningDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPositioningDate()
    {
        return isset($this->positioningDate) ? $this->positioningDate : null;
    }
    /**
     * Set positioningDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $positioningDate
     * @return \DBSchenker\StructType\ContainerType
     */
    public function setPositioningDate($positioningDate = null)
    {
        // validation for constraint: string
        if (!is_null($positioningDate) && !is_string($positioningDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($positioningDate, true), gettype($positioningDate)), __LINE__);
        }
        if (is_null($positioningDate) || (is_array($positioningDate) && empty($positioningDate))) {
            unset($this->positioningDate);
        } else {
            $this->positioningDate = $positioningDate;
        }
        return $this;
    }
    /**
     * Get sealNumber value
     * @return string|null
     */
    public function getSealNumber()
    {
        return $this->sealNumber;
    }
    /**
     * Set sealNumber value
     * @param string $sealNumber
     * @return \DBSchenker\StructType\ContainerType
     */
    public function setSealNumber($sealNumber = null)
    {
        // validation for constraint: string
        if (!is_null($sealNumber) && !is_string($sealNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sealNumber, true), gettype($sealNumber)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($sealNumber) && mb_strlen($sealNumber) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($sealNumber)), __LINE__);
        }
        $this->sealNumber = $sealNumber;
        return $this;
    }
}
